% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_btf.R
\name{btf_nb}
\alias{btf_nb}
\title{MCMC Sampler for Bayesian Trend Filtering with Negative Binomial Observation Model}
\usage{
btf_nb(
  y,
  evol_error = "DHS",
  D = 2,
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  mcmc_params = list("mu", "yhat", "evol_sigma_t2", "r", "dhs_phi", "dhs_mean"),
  r_init = NULL,
  r_sample = TRUE,
  step = 1,
  evol0_sample = FALSE,
  evol0_sd = 10,
  sigma_e = 1/sqrt(Nt),
  chol0 = NULL,
  computeDIC = TRUE,
  offset = 0,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{y}{the length \code{T} vector of time series observations; expected to be in the support of a Negative Binomial distribution}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior; the default), 'HS' (horseshoe prior), 'BL' (Bayesian lasso), or 'NIG' (normal-inverse-gamma prior)}

\item{D}{degree of differencing (D = 0, D = 1, or D = 2)}

\item{nsave}{number of MCMC iterations to record}

\item{nburn}{number of MCMC iterations to discard (burnin)}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{mcmc_params}{character list of parameters for which we store the MCMC output;
must be one or more of:
\itemize{
\item 'mu' (conditional mean)
\item 'yhat' (posterior predictive distribution)
\item 'evol_sigma_t2' (evolution error variance)
\item 'r' (overdispersion)
\item 'dhs_phi' (DHS AR(1) coefficient)
\item 'dhs_mean' (DHS AR(1) unconditional mean)
}
Defaults to everything.}

\item{r_init}{numeric; initial value (defaults to 5) of MCMC sampling for
overdispersion parameter; must be an integer if r_sample is 'int_mh' or
\code{NULL} (initializes to default of 5)}

\item{r_sample}{logical; If \code{TRUE} (default), the overdispersion is sampled,
else it is fixed at \code{r_init};}

\item{step}{numeric (defaults to 1); step length of proposal distribution for
Metropolis-Hasting sampling of overdispersion parameter; ignored if r_sample is \code{FALSE}}

\item{evol0_sample}{logical; if \code{TRUE} (default), the prior variance of the initial \code{D} values of mu is sampled,
else it is fixed at \code{evol0_sd}}

\item{evol0_sd}{numeric; initial value (defaults to 10) or the fixed prior standard deviation
for the initial \code{D} values of mu}

\item{sigma_e}{numeric; scale value (defaults to \code{1/sqrt(T)}) for half-Cauchy prior on global variance parameter}

\item{chol0}{logical; If anything except \code{NULL} (the default), the Cholesky term of the log volatility is precomputed}

\item{computeDIC}{logical; if TRUE, compute the deviance information criterion \code{DIC}
and the effective number of parameters \code{p_d}}

\item{offset}{length \code{T} vector of offset values for the log conditional expectation}

\item{verbose}{logical; If TRUE (the default), time remaining is printed to console}

\item{seed}{optional seed for random number generation for reproducible results}
}
\value{
A named list with the following. One named element for each of the parameters specified in \code{mcmc_params} containing
the \code{nsave} posterior draws as a vector for scalar parameters and matrix for multivariate parameters.
An element named \code{loglike} containing a vector of the \code{nsave} evaluations of the log
likelihood of the data \code{y} with a Negative Binomial distribution defined by the current iteration conditional expectation + offset and overdispersion.
If \code{computeDIC} is \code{TRUE}, a named element for the computed value of DIC and effective parameters p_d for the data \code{y}
with a Negative Binomial distribution defined by the posterior mean of the conditional expectation + offset and posterior
mean overdispersion.
}
\description{
Run the MCMC for Bayesian trend filtering with a penalty on first (D = 1) or
second (D = 2) differences of the log conditional expectation
of a Negative Binomial distribution. The penalty is determined by the prior
on the evolution errors, currently only the following options are available:
\itemize{
\item the dynamic horseshoe prior ('DHS');
\item the static horseshoe prior ('HS');
}
In each case, the evolution error is a scale mixture of Gaussians.
Sampling is accomplished with a (parameter-expanded) Gibbs sampler,
mostly relying on a dynamic linear model representation.
}
\keyword{internal}
