% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_n_q.R
\name{e_n_q}
\alias{e_n_q}
\title{Grassberger's expectation of n^q}
\usage{
e_n_q(n, q)
}
\arguments{
\item{n}{A positive integer vector.}

\item{q}{A positive number.}
}
\value{
A vector of the same length as n containing the transformed values.
}
\description{
Expected value of \eqn{n^q} when \eqn{n} follows a Poisson distribution
of parameter \eqn{n}.
}
\details{
The expectation of \eqn{n^q} when \eqn{n} follows a Poisson distribution
was derived by \insertCite{Grassberger1988;textual}{divent}.

It is computed using the \link{beta} function.
Its value is 0 for \eqn{n-q+1<0}, and close to 0 when \eqn{n=q},
which is not a correct estimate: it should not be used when \eqn{q > n}.
}
\examples{
n <- 10
q <- 2
# Compare
e_n_q(n, q)
# with (empirical estimation)
mean(rpois(1000, lambda = n)^q)
# and (naive estimation)
n^q

}
\references{
\insertAllCited{}
}
