% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{profile_plot}
\alias{profile_plot}
\title{Profile plot}
\usage{
profile_plot(
  dataSrc,
  item_property,
  covariate,
  predicate = NULL,
  model = c("IM", "RM"),
  x = NULL,
  col = NULL,
  col.diagonal = "lightgray",
  ...
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database or a data.frame with columns: 
person_id, item_id, item_score and the item_property and the covariate of interest.}

\item{item_property}{The name of the item property defining the domains. 
The item property should have exactly two distinct values in your data}

\item{covariate}{name of the person property used to create the groups. 
There will be one line for each distinct value.}

\item{predicate}{An optional expression to filter data, if NULL all data is used}

\item{model}{"IM" (default) or "RM" where "IM" is the interaction model and 
"RM" the Rasch model. The interaction model is the default as it fits 
the data better or at least as good as the Rasch model.}

\item{x}{Which category of the item_property to draw on the x axis, if NULL, one is chosen automatically}

\item{col}{vector of colors to use for plotting}

\item{col.diagonal}{color of the diagonal lines representing the testscores}

\item{...}{further graphical arguments to plot. Graphical parameters for the legend can be postfixed with \code{.legend}}
}
\description{
Compare how subgroups attain a test score with respect to an item property. 
\strong{Note}: this function works for complete data (i.e. a single booklet/test form). If incomplete data is supplied, it will attempt to 
make a profile plot only for those items that were administered to all respondents.
}
\details{
Profile plots can be used to investigate whether typically two, but possibly more, groups of respondents 
attain the same test score in the same way. The user must provide a  
meaningful classification of the items in two non-overlapping subsets such that 
the test score is the sum of the score on the subsets. 
The plot shows the expected scores on each subset of items given the test score, with diagonal lines indicating  
the same test score. The colored lines connect the most likely 
combination for each test score in each group.
When applied to educational test data, the plots can be used to detect differences in the 
relative difficulty of (sets of) items for respondents that belong to different 
groups. This provides a content-driven way to 
investigate differential item functioning.
}
\examples{

\dontshow{ RcppArmadillo::armadillo_throttle_cores(1)}

db = start_new_project(verbAggrRules, ":memory:", 
                         person_properties=list(gender="unknown"))
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)
profile_plot(db, item_property='mode', covariate='gender')

close_project(db)

\dontshow{ RcppArmadillo::armadillo_reset_cores()}

}
