% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{Ponerinae_tree_old_calib}
\alias{Ponerinae_tree_old_calib}
\title{Dataset providing the extensive time-calibrated phylogeny of extant ponerine ants using an old calibration for illustrative purposes}
\format{
A \code{phylo} object with 4 elements.
}
\usage{
data(Ponerinae_tree_old_calib)
}
\description{
A \code{phylo} object describing the time-calibrated phylogeny of the 1534 extant ponerine ants (Ponerinae subfamily).
This is NOT a properly time-calibrated phylogeny. It uses an ill-designed old calibration for illustrative purposes.
For a proper time-calibrated phylogeny of ponerine ants, see the \code{Ponerinae_tree} object in deepSTRAPP.

Source: Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\details{
A time-calibrated phylogeny as a \code{phylo} object with 4 elements.
\itemize{
\item \verb{$edge} Matrix of integers. Defines the tree topology by providing rootward and tipward node ID of each edge.
\item \verb{$edge.length} Vector of numerical. Length of edges/branches.
\item \verb{$Nnode} Integer. Number of internal nodes.
\item \verb{$tip.label} Vector of character strings. Labels of all tips.
}
}
\references{
Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\keyword{datasets}
