% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset.R
\name{get_dataset}
\alias{get_dataset}
\alias{dataset_metadata}
\alias{dataset_files}
\title{Get dataset metadata}
\usage{
get_dataset(
  dataset,
  version = ":latest",
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...,
  use_cache = Sys.getenv("DATAVERSE_USE_CACHE", cache_dataset(version))
)

dataset_metadata(
  dataset,
  version = ":latest",
  block = "citation",
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...,
  use_cache = Sys.getenv("DATAVERSE_USE_CACHE", cache_dataset(version))
)

dataset_files(
  dataset,
  version = ":latest",
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...,
  use_cache = Sys.getenv("DATAVERSE_USE_CACHE", cache_dataset(version))
)
}
\arguments{
\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}

\item{version}{A character specifying a version of the dataset.
This can be of the form \code{"1.1"} or \code{"1"} (where in \code{"x.y"}, x is a major
version and y is an optional minor version). As of v0.3.14, setting a version
in this way will cache the dataset (See example in \code{\link{cache_dataset}})
so that it will not re-download the file the second time and read from the cache.
Finally, set \code{use_cache = "none"} to not read from the cache and re-download
afresh even when \code{version} is provided.
If the user specifies a \code{key} or \code{DATAVERSE_KEY} argument, they can access the
draft version by \code{":draft"} (the current draft) or \code{":latest"} (which will
prioritize the draft over the latest published version).}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \code{DATAVERSE_SERVER = "dataverse.harvard.edu"} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{...}{Additional arguments passed to an HTTP request function,
such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}. See \code{\link{use_cache}} for details
on how the \emph{R} dataverse package uses disk and session caches to
improve network performance.}

\item{use_cache}{one of \code{"disk"}, \code{"session"}, or \code{"none"}, describing how datasets are cached to reduce network traffic. See \code{\link{cache_dataset}} for details.}

\item{block}{A character string specifying a metadata block to retrieve.
By default this is \dQuote{citation}. Other values may be available, depending
on the dataset, such as \dQuote{geospatial} or \dQuote{socialscience}.}
}
\value{
A list of class \dQuote{dataverse_dataset} or a list of a form dependent
on the specific metadata block retrieved. \code{dataset_files} returns a list of
objects of class \dQuote{dataverse_file}.
}
\description{
Retrieve metadata. To actually download a data file,
see \code{\link{get_file}} or \code{\link{get_dataframe_by_name}}.
}
\details{
\code{get_dataset} retrieves details about a Dataverse dataset.

\code{dataset_metadata} returns a named metadata block for a dataset.
This is already returned by \code{\link{get_dataset}}, but this function allows
you to retrieve just a specific block of metadata, such as citation information.

\code{dataset_files} returns a list of files in a dataset, similar to
\code{\link{get_dataset}}. The difference is that this returns only a list of
\dQuote{dataverse_dataset} objects, whereas \code{\link{get_dataset}} returns
metadata and a data.frame of files (rather than a list of file objects).
}
\examples{
\dontrun{
# https://demo.dataverse.org/dataverse/dataverse-client-r
Sys.setenv("DATAVERSE_SERVER" = "demo.dataverse.org")

# download file from:
dv <- get_dataverse("dataverse-client-r")
contents <- dataverse_contents(dv)[[1]]

dataset_files(contents[[1]])
get_dataset(contents[[1]])
dataset_metadata(contents[[1]])

Sys.unsetenv("DATAVERSE_SERVER")
}
}
\seealso{
\code{\link{get_file}}
}
