% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComplianceDocumentation.R
\name{ListComplianceDocTemplates}
\alias{ListComplianceDocTemplates}
\title{Retrieve information about all compliance doc templates.}
\usage{
ListComplianceDocTemplates(namePart = NULL, limit = NULL, offset = NULL)
}
\arguments{
\item{namePart}{character. Return only compliance doc templates that have a name that contains
this string.}

\item{limit}{integer. Return only this many compliance doc templates.}

\item{offset}{integer. Skip this many compliance doc templates before returning.}
}
\value{
list of available compliance doc templates. Contains:
 \itemize{
   \item name character. The name of the compliance doc template.
   \item creatorUsername character. The name of the user who created the compliance doc template.
   \item orgId character. The ID of the organization of the creator user.
   \item creatorId character. The ID of the creator user.
   \item sections list. The list of sections that define the template.
   \item id character. The ID of the template.
 }
}
\description{
Retrieve information about all compliance doc templates.
}
\examples{
\dontrun{
 # Get all compliance doc templates
 ListComplianceDocTemplates()
 Get the first three compliance doc templates with names that contain "foo".
 ListComplianceDocTemplates(namePart = "foo", limit = 3)
}
}
