% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_norm_zscore.R
\name{zscore}
\alias{zscore}
\title{Z-score normalization}
\usage{
zscore(nmean = 0, nsd = 1)
}
\arguments{
\item{nmean}{new mean for normalized data}

\item{nsd}{new standard deviation for normalized data}
}
\value{
returns the z-score transformation object
}
\description{
Standardize numeric columns to zero mean and unit variance, optionally rescaled to a target mean (\code{nmean}) and sd (\code{nsd}).
}
\details{
For each numeric column j, computes ((x - mean_j)/sd_j) * nsd + nmean. Constant columns become \code{nmean}.

\eqn{zscore = (x - mean(x))/sd(x)}
}
\examples{
data(iris)
head(iris)

trans <- zscore()
trans <- fit(trans, iris)
tiris <- transform(trans, iris)
head(tiris)

itiris <- inverse_transform(trans, tiris)
head(itiris)
}
\references{
Han, J., Kamber, M., Pei, J. (2011). Data Mining: Concepts and Techniques. (Standardization)
}
