% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crook_deform.R
\name{Create_Krok}
\alias{Create_Krok}
\title{Backwards-compatible wrapper keeping your original name/signature}
\usage{
Create_Krok(
  tree_stem,
  krok_length = 0.5,
  krok_start = 4,
  krok_type = "2dir",
  krok_deviation = 0.1,
  inflektion_X = 1/4,
  inflektion_ext = 1/2,
  az = 0,
  spar = 0.8
)
}
\arguments{
\item{tree_stem}{tree stem point cloud (lidR::LAS or data.frame)}

\item{krok_length}{range of the deformation along the stem's length}

\item{krok_start}{start height of the crook}

\item{krok_type}{single- or double-directional deviation}

\item{krok_deviation}{extent of the deviation}

\item{inflektion_X}{placement of double directional deviation}

\item{inflektion_ext}{placement of double directional deviation}

\item{az}{numeric degrees. Azimuth of lateral rotation (0 = X axis, 90 = Y axis). Default 0.}

\item{spar}{smoothing parameter for \code{stats::smooth.spline} (0..1).}
}
\value{
Same class as input (LAS or data.frame object with crook deformation)
}
\description{
Backwards-compatible wrapper keeping your original name/signature
}
