% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_jags.R
\name{h_jags_add_dummy}
\alias{h_jags_add_dummy}
\title{Appending a Dummy Number for Selected Slots in Data}
\usage{
h_jags_add_dummy(object, where, dummy = 0)
}
\arguments{
\item{object}{(\code{GeneralData})\cr object into which dummy values will be added.}

\item{where}{(\code{character})\cr names of slots in \code{object} to which a \code{dummy}
number will be appended.}

\item{dummy}{(\code{number})\cr a dummy number that will be appended to selected
slots in \code{object}. Default to \code{0}.}
}
\value{
A \code{\link{GeneralData}} object with slots updated with dummy number.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A helper function that appends a dummy value to a given slots in \code{\link{GeneralData}}
class object, if and only if the total number of observations (as indicated
by \code{object@nObs}) equals to \code{1}. Otherwise, the \code{object} is not changed.
}
\note{
The main motivation behind this function is related to the \code{JAGS}.
If there is only one observation, the data is not passed correctly to
\code{JAGS}, i.e. e.g. \code{x} and \code{y} are treated like scalars in the data file.
Therefore it is necessary to add dummy values to the vectors in this case
As we don't change the number of observations (\code{nObs}), this addition of
zeros doesn't affect the results of \code{JAGS} computations.
}
\examples{
# Create some data of class 'Data'
my_data <- Data(
  x = 0.1,
  y = 0,
  doseGrid = c(0.1, 0.5)
)

my_data_2 <- Data(
  x = c(0.1, 0.5),
  y = c(0, 1),
  doseGrid = c(0.1, 0.5)
)

# Append dummy to `x` and `y`.
h_jags_add_dummy(my_data, where = c("x", "y"))

# Append dummy to `x` and `y`. No effect as `my_data_2@nObs != 1`.
h_jags_add_dummy(my_data_2, where = c("x", "y"))
}
