% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_check_fun_formals}
\alias{h_check_fun_formals}
\title{Checking Formals of a Function}
\usage{
h_check_fun_formals(fun, mandatory = NULL, allowed = NULL)
}
\arguments{
\item{fun}{(\code{function})\cr a function name whose argument names will be
checked.}

\item{mandatory}{(\code{character} or \code{NULL})\cr the names of the arguments which
must be present in \code{fun}. If \code{mandatory} is specified as \code{NULL} (default)
this requirement is ignored.}

\item{allowed}{(\code{character} or \code{NULL})\cr the names of the arguments which
are allowed in \code{fun}. Names that do not belong to \code{allowed} are simply not
allowed. The \code{allowed} parameter is independent from the \code{mandatory}, in a
sense that if \code{mandatory} is specified as a \code{character} vector, it does not
have to be repeated in \code{allowed}. If \code{allowed} is specified as \code{NULL}
(default), then it means that there must be no any arguments in \code{fun}
(except these ones which are specified in \code{mandatory}).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This helper function checks whether a given function \code{fun} has required or
allowed arguments. The argument check is based only on the names of the
arguments. No any further logic is verified here.
}
