% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_range}
\alias{check_range}
\alias{assert_range}
\alias{test_range}
\alias{expect_range}
\title{Check that an argument is a numerical range}
\usage{
check_range(x, lower = -Inf, upper = Inf, finite = FALSE, unique = TRUE)

assert_range(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  unique = TRUE,
  .var.name = checkmate::vname(x),
  add = NULL
)

test_range(x, lower = -Inf, upper = Inf, finite = FALSE, unique = TRUE)

expect_range(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  unique = TRUE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
\code{TRUE} if successful, otherwise a string with the error message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

An argument \code{x} is a numerical range if and only if (all conditions must be met):
\enumerate{
\item Is an object of type: \code{integer} or \code{double}.
\item Is a vector or length two such that the value of the first number is not
less than the second number. Equalness is allowed if and only if \code{unique} flag
is set to \code{TRUE}.
\item Lower bound of the interval is greater than or equal to \code{lower} and
upper bound of the interval is less than or equal to \code{upper}.
\item It contains only finite (given that \code{finite} is \code{TRUE}) and non-missing values.
}
}
\examples{
check_range(c(1, 5))
check_range(c(-5, 1))
check_range(c(4, 1))
check_range(c(1, 1))
check_range(c(1, 1), unique = FALSE)
check_range(1:3)
}
\seealso{
\code{\link{assertions}} for more details.
}
