% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{FractionalCRM-class}
\alias{FractionalCRM-class}
\alias{.FractionalCRM}
\alias{FractionalCRM}
\alias{.DefaultFractionalCRM}
\title{\code{FractionalCRM}}
\usage{
FractionalCRM(...)

.DefaultFractionalCRM()
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=OneParLogNormalPrior]{OneParLogNormalPrior}}
  \describe{
    \item{\code{skel_probs}}{(\code{numeric})\cr skeleton prior probabilities. This is a vector
of unique and sorted probability values between 0 and 1.}
    \item{\code{dose_grid}}{(\code{numeric})\cr dose grid. It must be must be a sorted vector
of the same length as \code{skel_probs}.}
    \item{\code{sigma2}}{(\code{number})\cr prior variance of log power parameter alpha.}
  }}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{FractionalCRM}} is the class for a fractional CRM model based on a one
parameter CRM (with normal prior on the log-power parameter) as well as
Kaplan-Meier based estimation of the conditional probability to experience a
DLT for non-complete observations.

This fractional CRM model follows the paper and code by \insertCite{YinZhengXu2013;textual}{crmPack}.
}
\note{
Typically, end users will not use the \code{.DefaultTITELogisticLogNormal()} function.
}
\examples{
my_model <- FractionalCRM(
  skel_probs = c(0.1, 0.2, 0.3, 0.4),
  dose_grid = c(10, 30, 50, 100),
  sigma2 = 2
)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{TITELogisticLogNormal}}.
}
