% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointRW-class}
\alias{DualEndpointRW-class}
\alias{.DualEndpointRW}
\alias{DualEndpointRW}
\alias{.DefaultDualEndpointRW}
\title{\code{DualEndpointRW}}
\usage{
DualEndpointRW(sigma2betaW, rw1 = TRUE, ...)

.DefaultDualEndpointRW()
}
\arguments{
\item{sigma2betaW}{(\code{numeric})\cr the prior variance factor of the random walk
prior for the biomarker model. Either a fixed value or Inverse-Gamma distribution
parameters, i.e. vector with two elements named \code{a} and \code{b}.}

\item{rw1}{(\code{flag})\cr for specifying the random walk prior on the biomarker
level. When \code{TRUE}, random walk of first order is used. Otherwise, the
random walk of second order is used.}

\item{...}{parameters passed to \code{\link[=DualEndpoint]{DualEndpoint()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{DualEndpointRW}} is the class for the dual endpoint model with random walk
prior for biomarker.
}
\details{
This class extends the \code{\link{DualEndpoint}} class so that the dose-biomarker
relationship \eqn{f(x)} is modelled by a non-parametric random walk of first
or second order. That means, for the first order random walk we assume
\deqn{betaW_i - betaW_i-1 ~ Normal(0, (x_i - x_i-1) * sigma2betaW),}
where \eqn{betaW_i = f(x_i)} is the biomarker mean at the \eqn{i}-th dose
gridpoint \eqn{x_i}.
For the second order random walk, the second-order differences instead of
the first-order differences of the biomarker means follow the normal distribution
with \eqn{0} mean and \eqn{2 * (x_i - x_i-2) * sigma2betaW} variance.

The variance parameter \eqn{sigma2betaW} is important because it steers the
smoothness of the function \eqn{f(x)}, i.e.: if it is large, then \eqn{f(x)}
will be very wiggly; if it is small, then \eqn{f(x)} will be smooth.
This parameter can either be a fixed value or assigned an inverse gamma prior
distribution.
}
\section{Slots}{

\describe{
\item{\code{sigma2betaW}}{(\code{numeric})\cr the prior variance factor of the random walk
prior for the biomarker model. Either a fixed value or Inverse-Gamma distribution
parameters, i.e. vector with two elements named \code{a} and \code{b}.}

\item{\code{rw1}}{(\code{flag})\cr for specifying the random walk prior on the biomarker
level. When \code{TRUE}, random walk of first order is used. Otherwise, the
random walk of second order is used.}
}}

\note{
Non-equidistant dose grids can be used now, because the difference
\eqn{x_i - x_i-1} is included in the modelling assumption above.
Please note that due to impropriety of the random walk prior distributions,
it is not possible to produce MCMC samples with empty data objects (i.e.,
sample from the prior). This is not a bug, but a theoretical feature of this
model.

Typically, end users will not use the \code{.DefaultDualEndpointRW()} function.
}
\examples{
my_model <- DualEndpointRW(
  mean = c(0, 1),
  cov = matrix(c(1, 0, 0, 1), nrow = 2),
  sigma2W = c(a = 0.1, b = 0.1),
  rho = c(a = 1, b = 1),
  sigma2betaW = 0.01,
  rw1 = TRUE
)
}
\seealso{
\code{\link{DualEndpoint}}, \code{\link{DualEndpointBeta}}, \code{\link{DualEndpointEmax}}.
}
