# This file is a direct copy from ddsjoberg/gtforester
# usethis::use_github_file("MSKCC-Epi-Bio/bstfun", "R/as_ggplot.R")

#' Convert gt/gtsummary table to ggplot
#'
#' useful when you want to place a ggplot and gt table side-by-side.
#' To use this function you must install the magick R package AND system program
#' (see https://docs.ropensci.org/magick/articles/intro.html#installing-magick-1)
#'
#' @param x gt or gtsummary table
#' @param ... arguments passed to `gt::gtsave()`
#' @keywords internal
#' @return a ggplot object
#'
#' @family gtsummary-related functions
as_ggplot <- function(x, ...) {
  # checks ---------------------------------------------------------------------
  if (!inherits(x, c("gt_tbl", "gtsummary"))) stop("`x=` must be a 'gt' or 'gtsummary' table", call. = FALSE)
  .assert_package("magick", "as_ggplot")
  .assert_package("ggtext", "as_ggplot")

  # convert gtsummary to gt ----------------------------------------------------
  if (inherits(x, "gtsummary")) x <- gtsummary::as_gt(x)

  # save gt as image -----------------------------------------------------------
  path_gt_table_image <- tempfile(fileext = ".png")
  # path_gt_table_image <- fs::file_temp(ext = "png")
  # on.exit(if (fs::file_exists(path_gt_table_image)) fs::file_delete(path_gt_table_image), add = TRUE)
  gt_table_image <- gt::gtsave(x, filename = path_gt_table_image, ...)

  # save image in ggplot -------------------------------------------------------
  suppressWarnings(
    table_img <-
      magick::image_read(path_gt_table_image) %>%
      magick::image_ggplot(interpolate = TRUE)
  )
  unlink(path_gt_table_image)
  table_img
}
