% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armed_bandit_helpers.R
\name{BatchLinUCBDisjointPolicyEpsilon}
\alias{BatchLinUCBDisjointPolicyEpsilon}
\title{Batch Disjoint LinUCB Policy with Epsilon-Greedy}
\description{
Batch Disjoint LinUCB Policy with Epsilon-Greedy

Batch Disjoint LinUCB Policy with Epsilon-Greedy
}
\details{
Implements the disjoint LinUCB algorithm with upper confidence bounds and epsilon-greedy exploration, using batched updates.
}
\section{Methods}{

- `initialize(alpha = 1.0, epsilon = 0.1, batch_size = 1)`: Constructor.
- `set_parameters(context_params)`: Initializes sufficient statistics for each arm.
- `get_action(t, context)`: Selects an arm using UCB scores and epsilon-greedy rule.
- `set_reward(t, context, action, reward)`: Updates statistics and refreshes model at batch intervals.
}

\section{Super class}{
\code{cramR::NA} -> \code{BatchLinUCBDisjointPolicyEpsilon}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{alpha}}{Numeric, UCB exploration strength parameter.}

\item{\code{epsilon}}{Numeric, probability of taking a random exploratory action.}

\item{\code{batch_size}}{Integer, number of rounds per batch update.}

\item{\code{A_cc}}{List of Gram matrices per arm, accumulated across batch.}

\item{\code{b_cc}}{List of reward-weighted context vectors per arm.}

\item{\code{class_name}}{Internal class name identifier.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BatchLinUCBDisjointPolicyEpsilon-new}{\code{BatchLinUCBDisjointPolicyEpsilon$new()}}
\item \href{#method-BatchLinUCBDisjointPolicyEpsilon-set_parameters}{\code{BatchLinUCBDisjointPolicyEpsilon$set_parameters()}}
\item \href{#method-BatchLinUCBDisjointPolicyEpsilon-get_action}{\code{BatchLinUCBDisjointPolicyEpsilon$get_action()}}
\item \href{#method-BatchLinUCBDisjointPolicyEpsilon-set_reward}{\code{BatchLinUCBDisjointPolicyEpsilon$set_reward()}}
\item \href{#method-BatchLinUCBDisjointPolicyEpsilon-clone}{\code{BatchLinUCBDisjointPolicyEpsilon$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="initialize_theta"><a href='../../cramR/html/NA.html#method-NA-initialize_theta'><code>cramR::NA$initialize_theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="post_initialization"><a href='../../cramR/html/NA.html#method-NA-post_initialization'><code>cramR::NA$post_initialization()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BatchLinUCBDisjointPolicyEpsilon-new"></a>}}
\if{latex}{\out{\hypertarget{method-BatchLinUCBDisjointPolicyEpsilon-new}{}}}
\subsection{Method \code{new()}}{
Constructor for batched LinUCB with epsilon-greedy exploration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchLinUCBDisjointPolicyEpsilon$new(alpha = 1, epsilon = 0.1, batch_size = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{Numeric. UCB width parameter (exploration strength).}

\item{\code{epsilon}}{Numeric. Probability of selecting a random arm.}

\item{\code{batch_size}}{Integer. Number of rounds before updating parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BatchLinUCBDisjointPolicyEpsilon-set_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-BatchLinUCBDisjointPolicyEpsilon-set_parameters}{}}}
\subsection{Method \code{set_parameters()}}{
Initialize arm-specific parameter containers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchLinUCBDisjointPolicyEpsilon$set_parameters(context_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context_params}}{List containing at least `unique` (feature size) and `k` (number of arms).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BatchLinUCBDisjointPolicyEpsilon-get_action"></a>}}
\if{latex}{\out{\hypertarget{method-BatchLinUCBDisjointPolicyEpsilon-get_action}{}}}
\subsection{Method \code{get_action()}}{
Chooses an arm based on UCB and epsilon-greedy sampling.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchLinUCBDisjointPolicyEpsilon$get_action(t, context)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer timestep.}

\item{\code{context}}{List containing the context for the decision.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the selected action.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BatchLinUCBDisjointPolicyEpsilon-set_reward"></a>}}
\if{latex}{\out{\hypertarget{method-BatchLinUCBDisjointPolicyEpsilon-set_reward}{}}}
\subsection{Method \code{set_reward()}}{
Updates arm-specific sufficient statistics based on observed reward.
Parameter updates occur only at the end of a batch.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchLinUCBDisjointPolicyEpsilon$set_reward(t, context, action, reward)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer timestep.}

\item{\code{context}}{Context object used for decision-making.}

\item{\code{action}}{List containing the chosen action.}

\item{\code{reward}}{List containing the observed reward.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated internal model parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BatchLinUCBDisjointPolicyEpsilon-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BatchLinUCBDisjointPolicyEpsilon-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchLinUCBDisjointPolicyEpsilon$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
