% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{sinkhorn_to_assignment}
\alias{sinkhorn_to_assignment}
\title{Round 'Sinkhorn' transport plan to hard assignment}
\usage{
sinkhorn_to_assignment(result)
}
\arguments{
\item{result}{Either a result from \code{\link[=sinkhorn]{sinkhorn()}} or a transport plan matrix.}
}
\value{
Integer vector of column assignments (1-based), same format as
\code{\link[=assignment]{assignment()}}.
}
\description{
Convert a soft transport plan from \code{\link[=sinkhorn]{sinkhorn()}} to a hard 1-to-1 assignment
using greedy rounding.
}
\details{
Greedy rounding iteratively assigns each row to its most probable column,
ensuring no column is assigned twice. This may not give the globally optimal
hard assignment; for that, use the transport plan as a cost matrix with
\code{\link[=assignment]{assignment()}}.
}
\examples{
cost <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8, 9), nrow = 3, byrow = TRUE)
result <- sinkhorn(cost, lambda = 20)
hard_match <- sinkhorn_to_assignment(result)
print(hard_match)

}
\seealso{
\code{\link[=sinkhorn]{sinkhorn()}}
}
