% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{countdown_update}
\alias{countdown_update}
\title{Update a Countdown Timer in a Shiny App}
\usage{
countdown_update(
  id,
  ...,
  minutes = NULL,
  seconds = NULL,
  warn_when = NULL,
  update_every = NULL,
  blink_colon = NULL,
  play_sound = NULL,
  session = NULL
)
}
\arguments{
\item{id}{A character vector with one or more \code{id} values for timers created
with \code{\link[=countdown]{countdown()}} or \code{\link[=countdown_fullscreen]{countdown_fullscreen()}}. Be sure to set the \code{id}
value when creating the timer.}

\item{...}{Ignored, but included for future compatibility.}

\item{minutes}{The number of minutes for which the timer should run. This
value is added to \code{seconds}.}

\item{seconds}{The number of seconds for which the timer should run. This
value is added to \code{minutes}.}

\item{warn_when}{Change the countdown to "warning" state when \code{warn_when}
seconds remain. This is achieved by adding the \code{warning} class to the timer
when \code{warn_when} seconds or less remain. Only applied when greater than
\code{0}.}

\item{update_every}{Update interval for the timer, in seconds. When this
argument is greater than \code{1}, the timer run but the display will only
update, once every \code{update_every} seconds. The timer will switch to normal
second-by-second updating for the last two \code{update_every} periods.}

\item{blink_colon}{Adds an animation to the blink the colon of the digital
timer at each second. Because the blink animation is handled via CSS and
not by the JavaScript process that decrements the timer, so the animation
may fall out of sync with the timer. For this reason, the blink animation
is only shown, by default, when \code{update_every} is greater than 1, i.e. when
the countdown time is updated periodically rather than each second.}

\item{play_sound}{Play a sound at the end of the timer? If \code{TRUE}, plays the
"stage complete" sound courtesy of \link[beepr:beepr-package]{beepr}.
Alternatively, \code{play_sound} can be a relative or absolute URL to a sound
file, such as an \code{mp3}, \code{wav}, \code{ogg}, or other audio file type.
Custom sounds are only played when \code{countdown} is used on a webpage or
Shiny app; however, they do not work in an interactive context (creating
a \code{countdown} in console) due to JavaScript limitations in accessing
local files.}

\item{session}{The reactive \code{session} object for the current Shiny session.
In general, only required for expert or unusual use cases.}
}
\value{
Invisibly returns the options sent to update the countdown timer(s).
}
\description{
Updates the settings of a countdown timer dynamically in a Shiny app via
server logic. See \code{\link[=countdown_shiny_example]{countdown_shiny_example()}} for an example app
demonstrating the usage of \code{countdown_update()}.
}
\seealso{
Other Shiny functions: 
\code{\link{countdown_action}()},
\code{\link{countdown_app}()},
\code{\link{countdown_shiny_example}()}
}
\concept{Shiny functions}
