% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_sum.R
\name{sum_code}
\alias{sum_code}
\title{Use sum coding}
\usage{
sum_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Same as \link[stats]{contr.sum}, but ensures that the reference level
is the first level alphabetically, not the last. Returns a contrast matrix
where comparisons give differences between comparison levels and the grand
mean.
}
\details{
For n levels of factors, generate a matrix with n-1 comparisons where:
\itemize{
\item Reference level = -1
\item Comparison level = 1
\item All others = 0
}

Example interpretation for a 4 level factor:
\itemize{
\item Intercept = Grand mean (mean of the means of each level)
\item grp2 = grp2 - mean(grp4, grp3, grp2, grp1)
\item grp3 = grp3 - mean(grp4, grp3, grp2, grp1)
\item grp4 =  grp4 - mean(grp4, grp3, grp2, grp1)
}

Note that when n = 2, the coefficient estimate is half of the difference
between the two levels. But, this coincidence does not hold when the number
of levels is greater than 2.
}
\examples{
mydf <- data.frame(
  grp = gl(4,5),
  resp = c(seq(1, 5), seq(5, 9), seq(10, 14), seq(15, 19))
)

mydf <- set_contrasts(mydf, grp ~ sum_code)

lm(resp ~ grp, data = mydf)

}
