% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R,
%   R/logger_generics.R
\name{download_cnt}
\alias{download_cnt}
\alias{download_cnt.ConnectorFS}
\alias{download_cnt.ConnectorLogger}
\title{Download content from the connector}
\usage{
download_cnt(connector_object, src, dest = basename(src), ...)

\method{download_cnt}{ConnectorFS}(connector_object, src, dest = basename(src), ...)

\method{download_cnt}{ConnectorLogger}(connector_object, src, dest = basename(src), ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{src}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{dest}{\link{character} Path to the file to download to or upload from}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to download files from a connector:

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:copy]{fs::file_copy()}} to copy a file from the file storage
to the desired \code{file}.
}

\itemize{
\item \link{ConnectorLogger}: Logs the download operation and calls the underlying connector method.
}
}
\examples{
# Download file from a file storage

folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connector_fs(folder)

cnt |>
  write_cnt("this is an example", "example.txt")

list.files(pattern = "example.txt")

cnt |>
  download_cnt("example.txt")

list.files(pattern = "example.txt")
readLines("example.txt")

cnt |>
  remove_cnt("example.txt")

# Add logging to a file system connector for downloads
folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connectors(data = connector_fs(folder)) |> add_logs()

cnt$data |>
  write_cnt(iris, "iris.csv")

cnt$data |>
  download_cnt("iris.csv", tempfile(fileext = ".csv"))

}
