% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%p\%}
\alias{\%p\%}
\title{An infix operator for \code{paste0()}}
\usage{
x \%p\% y
}
\arguments{
\item{x}{A value for the left side of the paste infix operator.}

\item{y}{A value for the right side of the paste infix operator.}
}
\value{
The concatenated or pasted value.  No spaces will be inserted
in between the values to paste. If a vector of values is supplied,
a vector of pasted values will be returned.
}
\description{
This function provides an infix operator for the
\code{\link{paste0}} function to concatenate strings.  The operator
will concatenate a vector of one or more values. The functionality
is identical to \code{paste0()}, but more convenient to use in some
situations.
}
\examples{
# Paste together two strings
str <- "Hello" \%p\% "World"
str
# [1] "HelloWorld"

# Paste together number and string
str <- 100 \%p\% " Kittens"
str
# [1] "100 Kittens"

# Paste together two vectors
v1 <- c("A", "B", "C")
v2 <- c(1, 2, 3)
str <- v1 \%p\% v2
str
# [1] "A1" "B2" "C3"
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%ge\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%le\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%ne\%}()}
}
\concept{operators}
