% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_numeric_glm.R
\name{f_numeric_glm}
\alias{f_numeric_glm}
\title{R-squared of Gaussian GLM predictions vs. observations}
\usage{
f_numeric_glm(df, ...)
}
\arguments{
\item{df}{(required, dataframe) with columns:
\itemize{
\item \code{x}: (numeric, character, factor) predictor.
\item \code{y} (numeric) continuous response.
}}

\item{...}{(optional) Accepts the arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and Inf) for cross validation.}
}
\value{
numeric or numeric vector: R-squared
}
\description{
Fits a Gaussian GLM model \code{y ~ x} with the numeric response \code{y} and the numeric, character, or factor predictor \code{x} using \code{stats::glm()} and returns the R-squared of the observations against the predictions (see \code{\link[=score_r2]{score_r2()}}).

Supports cross-validation via the arguments arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and \code{n}) introduced via ellipsis (\code{...}). See \code{\link[=preference_order]{preference_order()}} for further details.
}
\examples{

data(vi_smol)

df <- data.frame(
  y = vi_smol[["vi_numeric"]],
  x = vi_smol[["swi_max"]]
)

#no cross-validation
f_numeric_glm(df = df)

#cross-validation
f_numeric_glm(
  df = df,
  cv_training_fraction = 0.5,
  cv_iterations = 10
  )

#categorical predictor
df <- data.frame(
  y = vi_smol[["vi_numeric"]],
  x = vi_smol[["koppen_zone"]]
)

f_numeric_glm(df = df)

}
\seealso{
Other preference_order_functions: 
\code{\link{f_binomial_gam}()},
\code{\link{f_binomial_glm}()},
\code{\link{f_binomial_rf}()},
\code{\link{f_categorical_rf}()},
\code{\link{f_count_gam}()},
\code{\link{f_count_glm}()},
\code{\link{f_count_rf}()},
\code{\link{f_numeric_gam}()},
\code{\link{f_numeric_rf}()},
\code{\link{preference_order}()}
}
\concept{preference_order_functions}
