\name{scorten_score}
\alias{scorten_score}
\title{
SCORTEN: Severity-of-Illness Score for Toxic Epidermal Necrolysis
}
\description{
Calculates the SCORTEN score to predict mortality in patients with Toxic Epidermal Necrolysis (TEN) or Stevens-Johnson Syndrome (SJS). The score is calculated within the first 24 hours of admission and consists of seven independent risk factors.
}
\usage{
scorten_score(age_years, heart_rate, malignancy, bsa_detached_percent,
              bun, bicarbonate, glucose, bun_units = "mg/dL",
              glucose_units = "mg/dL")
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. (>= 40 years adds 1 point).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 120 bpm adds 1 point).
}
  \item{malignancy}{
Numeric (0 or 1). Presence of associated cancer/malignancy. (1 = Yes, adds 1 point).
}
  \item{bsa_detached_percent}{
Numeric. Percentage of body surface area detached. (>= 10\% adds 1 point).
}
  \item{bun}{
Numeric. Serum Urea (BUN) level. (> 10 mmol/L or > 28 mg/dL adds 1 point).
}
  \item{bicarbonate}{
Numeric. Serum Bicarbonate level in mmol/L (mEq/L). (< 20 mmol/L adds 1 point).
}
  \item{glucose}{
Numeric. Serum Glucose level. (> 14 mmol/L or > 252 mg/dL adds 1 point).
}
  \item{bun_units}{
String. Units for BUN input. Options: "mg/dL" (default) or "mmol/L".
}
  \item{glucose_units}{
String. Units for Glucose input. Options: "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{SCORTEN_Score}{The calculated total score (Range 0-7).}
\item{Estimated_Mortality}{The estimated probability of hospital mortality based on the score.}
}
\references{
Bastuji-Garin S, Fouchard N, Bertocchi M, et al. SCORTEN: a severity-of-illness score for toxic epidermal necrolysis. J Invest Dermatol. 2000;115(2):149-153. doi:10.1046/j.1523-1747.2000.00061.x
}
\examples{

# Example 1: Low Risk
# 30yo, HR 80, No cancer, 5% BSA, BUN 15 mg/dL, Bicarb 24, Glucose 100 mg/dL
# Score = 0
scorten_score(30, 80, 0, 5, 15, 24, 100)

# Example 2: High Risk
# 50yo (+1), HR 130 (+1), No cancer, 20% BSA (+1),
#BUN 40 mg/dL (+1), Bicarb 18 (+1), Glucose 300 mg/dL (+1)
# Score = 6
scorten_score(50, 130, 0, 20, 40, 18, 300)
}
