\name{rox_index_score}
\alias{rox_index_score}
\title{
ROX Index for Intubation Risk after HFNC
}
\description{
Calculates the ROX Index (Respiratory rate-Oxygenation) to predict the success or failure of High-Flow Nasal Cannula (HFNC) therapy in patients with acute hypoxemic respiratory failure. The index is defined as the ratio of SpO2/FiO2 to Respiratory Rate. A lower score (< 2.85 to 4.88) indicates a higher risk of HFNC failure and the need for intubation.
}
\usage{
rox_index_score(spo2_percent, fio2_percent, respiratory_rate)
}
\arguments{
  \item{spo2_percent}{
Numeric. Oxygen saturation percentage (0-100).
}
  \item{fio2_percent}{
Numeric. Fraction of Inspired Oxygen (can be entered as percent 21-100 or decimal 0.21-1.0).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
}
\value{
A list containing:
\item{ROX_Index}{The calculated index value.}
\item{Interpretation}{Clinical interpretation based on risk thresholds (e.g., < 2.85, < 3.85, < 4.88, >= 4.88).}
}
\references{
Roca O, Messika J, Caralt B, et al. Predicting success of high-flow nasal cannula in pneumonia patients with hypoxemic respiratory failure: The utility of the ROX index. J Crit Care. 2016;35:200-205. doi:10.1016/j.jcrc.2016.05.022
Roca O, Caralt B, Messika J, et al. An Index Combining Respiratory Rate and Oxygenation to Predict Outcome of Nasal High-Flow Therapy. Am J Respir Crit Care Med. 2019;199(11):1368-1376.
}
\examples{

# Example 1: High Risk of Failure
# SpO2 88%, FiO2 1.0 (100%), RR 35
# Ratio = 88 / 1.0 = 88. Index = 88 / 35 = 2.51
rox_index_score(88, 100, 35)

# Example 2: Success Likely
# SpO2 95%, FiO2 0.4 (40%), RR 20
# Ratio = 95 / 0.4 = 237.5. Index = 237.5 / 20 = 11.88
rox_index_score(95, 40, 20)
}
