\name{ribscore_trauma}
\alias{ribscore_trauma}
\title{
RibScore for Predicting Pulmonary Complications
}
\description{
Calculates the RibScore to predict the risk of pulmonary complications (pneumonia, respiratory failure, or need for tracheostomy) in patients with rib fractures. The score is derived from six clinical variables: age, number of fractures, presence of bilateral fractures, flail chest, chronic lung disease, and pre-injury anticoagulant use.
}
\usage{
ribscore_trauma(age, fracture_count, bilateral_fractures, flail_chest,
                chronic_lung_disease, anticoagulant_use)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<45: 0 pts.
45-64: 1 pt.
>=65: 2 pts.
}
  \item{fracture_count}{
Numeric. Total number of rib fractures.
<3: 0 pts.
3-5: 1 pt.
>=6: 2 pts.
}
  \item{bilateral_fractures}{
Numeric (0 or 1). Presence of bilateral rib fractures. (1 = Yes, +2 pts).
}
  \item{flail_chest}{
Numeric (0 or 1). Presence of flail chest (segmental fractures of >=3 adjacent ribs). (1 = Yes, +2 pts).
}
  \item{chronic_lung_disease}{
Numeric (0 or 1). History of chronic lung disease (e.g., COPD, asthma). (1 = Yes, +2 pts).
}
  \item{anticoagulant_use}{
Numeric (0 or 1). Pre-injury use of anticoagulants (e.g., warfarin, DOACs, antiplatelets). (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{RibScore}{The calculated total score (Range 0-12).}
\item{Pulmonary_Complication_Risk}{Estimated percentage risk of pneumonia, respiratory failure, or tracheostomy.}
}
\references{
Chapman BC, Herbert B, Rodil M, et al. RibScore: A novel decision aid to predict pulmonary complications in patients with rib fractures. J Trauma Acute Care Surg. 2016;80(1):95-101. doi:10.1097/TA.0000000000000893
}
\examples{

# Example 1: High Risk
# 70yo (+2), 6 fractures (+2), Bilateral (+2), Flail (+2)
# Score = 8
ribscore_trauma(70, 6, 1, 1, 0, 0)

# Example 2: Low Risk
# 30yo (0), 2 fractures (0), No other factors
# Score = 0
ribscore_trauma(30, 2, 0, 0, 0, 0)
}
