\name{pen_fast_score}
\alias{pen_fast_score}
\title{
PEN-FAST Penicillin Allergy Decision Rule
}
\description{
Calculates the PEN-FAST score to identify low-risk penicillin allergy patients who may safely undergo direct oral challenge. The score uses three clinical criteria (Five years or less since reaction, Anaphylaxis/angioedema, Treatment required) and considers Severe Cutaneous Adverse Reactions (SCAR) as an exclusion/high-risk factor.
}
\usage{
pen_fast_score(five_years_or_less, anaphylaxis_or_angioedema,
               treatment_required, severe_cutaneous_reaction = 0)
}
\arguments{
  \item{five_years_or_less}{
Numeric (0 or 1). Did the reaction occur 5 years ago or less? (1 = Yes, +2 points).
}
  \item{anaphylaxis_or_angioedema}{
Numeric (0 or 1). Did the reaction involve anaphylaxis or angioedema? (1 = Yes, +2 points).
}
  \item{treatment_required}{
Numeric (0 or 1). Did the reaction require treatment? (1 = Yes, +1 point).
}
  \item{severe_cutaneous_reaction}{
Numeric (0 or 1). Is there a history of Severe Cutaneous Adverse Reaction (SCAR), such as SJS, TEN, or DRESS? (1 = Yes). Presence of SCAR typically contraindicates oral challenge regardless of the score.
}
}
\value{
A list containing:
\item{PEN_FAST_Score}{The calculated risk score (Range 0-5).}
\item{Risk_Category}{Risk classification (Low Risk < 3, Moderate/High Risk >= 3).}
\item{Interpretation}{Clinical guidance based on the score.}
}
\references{
Trubiano JA, Vogrin S, Chua KYL, et al. Development and Validation of a Penicillin Allergy Clinical Decision Rule. JAMA Intern Med. 2020;180(5):745-752. doi:10.1001/jamainternmed.2020.0403
}
\examples{

# Example 1: Low Risk
# Reaction >5 years ago (0), No anaphylaxis (0), Treatment required (1)
# Score = 1
pen_fast_score(0, 0, 1)

# Example 2: High Risk
# Reaction <5 years ago (2), Anaphylaxis (2), Treatment (1)
# Score = 5
pen_fast_score(1, 1, 1)
}
