\name{pediatric_trauma_score}
\alias{pediatric_trauma_score}
\title{
Pediatric Trauma Score (PTS)
}
\description{
Calculates the Pediatric Trauma Score (PTS) to assess injury severity in children. This tool aids in triage decisions, specifically identifying pediatric trauma patients who require transfer to a specialized pediatric trauma center. A score of 8 or lower indicates significant injury and potential for mortality.
}
\usage{
pediatric_trauma_score(weight_kg, airway_status, systolic_bp, cns_status,
                       open_wound_status, skeletal_fracture_status)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
>20 kg (+2)
10-20 kg (+1)
<10 kg (-1)
}
  \item{airway_status}{
String. Assessment of the airway.
"normal" (+2)
"maintainable" (+1)
"unmaintainable" (-1)
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
>90 (+2)
50-90 (+1)
<50 (-1)
}
  \item{cns_status}{
String. Central Nervous System status.
"awake" (+2)
"obtunded" (+1) (includes loss of consciousness)
"coma" (-1) (includes decerebrate posturing)
}
  \item{open_wound_status}{
String. Assessment of open wounds.
"none" (+2)
"minor" (+1)
"major" (-1) (includes penetrating wounds)
}
  \item{skeletal_fracture_status}{
String. Assessment of skeletal injuries.
"none" (+2)
"closed" (+1)
"open_multiple" (-1)
}
}
\value{
A list containing:
\item{PTS_Score}{The calculated Pediatric Trauma Score (Range -6 to 12).}
\item{Recommendation}{Triage guidance based on the threshold of 8.}
\item{Risk_Assessment}{Estimated mortality risk context.}
}
\references{
Tepas JJ 3rd, Mollitt DL, Talbert JL, Bryant M. The pediatric trauma score as a predictor of injury severity in the injured child. J Pediatr Surg. 1987;22(1):14-18. doi:10.1016/s0022-3468(87)80005-5
}
\examples{

# Example 1: Severe Trauma
# 9kg (-1), Unmaintainable (-1), SBP 45 (-1), Coma (-1), Major Wound (-1), Open Fx (-1)
# Score = -6
pediatric_trauma_score(9, "unmaintainable", 45, "coma", "major", "open_multiple")

# Example 2: Minor Trauma
# 25kg (+2), Normal Airway (+2), SBP 100 (+2), Awake (+2), Minor Wound (+1), None Fx (+2)
# Score = 11
pediatric_trauma_score(25, "normal", 100, "awake", "minor", "none")
}
