\name{pediatric_appendicitis_risk_calculator}
\alias{pediatric_appendicitis_risk_calculator}
\title{
Pediatric Appendicitis Risk Calculator (pARC)
}
\description{
Calculates the Pediatric Appendicitis Risk Calculator (pARC) score to estimate the probability of appendicitis in children presenting with abdominal pain. The score utilizes sex, age, pain duration, pain migration, guarding, maximal tenderness in the right lower quadrant (RLQ), and absolute neutrophil count (ANC).
}
\usage{
pediatric_appendicitis_risk_calculator(sex, age_years, pain_duration_hours,
                                       abdominal_pain_migration, abdominal_guarding,
                                       maximal_tenderness_rlq, absolute_neutrophil_count)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{pain_duration_hours}{
Numeric. Duration of abdominal pain in hours.
}
  \item{abdominal_pain_migration}{
Numeric (0 or 1). Migration of pain to the RLQ. (1 = Yes).
}
  \item{abdominal_guarding}{
Numeric (0 or 1). Presence of abdominal guarding on examination. (1 = Yes).
}
  \item{maximal_tenderness_rlq}{
Numeric (0 or 1). Is maximal tenderness located in the Right Lower Quadrant (RLQ)? (1 = Yes).
}
  \item{absolute_neutrophil_count}{
Numeric. Absolute Neutrophil Count (ANC) in x10^3/uL (or x10^9/L).
}
}
\value{
A list containing:
\item{PARC_Score}{The calculated risk score (points).}
\item{Appendicitis_Risk_Probability}{Estimated probability of appendicitis based on the score.}
}
\references{
Kharbanda AB, Vazquez-Benitez G,  Ballard DW, et al. Development and Validation of a Pediatric Appendicitis Risk Calculator (pARC). Pediatrics. 2018;141(4):e20172699. doi:10.1542/peds.2017-2699
}
\examples{

# Example 1: High Risk
# Male (+2), 10y (+7), Pain 36h (+4), Migration (+8), Guarding (+12),
#RLQ Tenderness (+16), ANC 15 (+49)
# Score = 98
pediatric_appendicitis_risk_calculator("male", 10, 36, 1, 1, 1, 15.0)

# Example 2: Low Risk
# Female (0), 4y (0), Pain 12h (0), No Migration, No Guarding, No RLQ Tenderness, ANC 5 (0)
# Score = 0
pediatric_appendicitis_risk_calculator("female", 4, 12, 0, 0, 0, 5.0)
}
