\name{pecarn_pediatric_iai_algorithm}
\alias{pecarn_pediatric_iai_algorithm}
\title{
PECARN Pediatric Intra-Abdominal Injury (IAI) Algorithm
}
\description{
Calculates the risk of Intra-Abdominal Injury (IAI) requiring acute intervention in children with blunt torso trauma using the PECARN prediction rule. The algorithm identifies patients at very low risk (<0.1\%) who may safely forego abdominal CT imaging.
}
\usage{
pecarn_pediatric_iai_algorithm(abdominal_wall_trauma_seatbelt_sign, gcs_lt_14,
                               abdominal_tenderness, thoracic_wall_trauma,
                               abdominal_pain, decreased_breath_sounds, vomiting)
}
\arguments{
  \item{abdominal_wall_trauma_seatbelt_sign}{
Numeric (0 or 1). Evidence of abdominal wall trauma or seatbelt sign (bruising, abrasion). (1 = Yes).
}
  \item{gcs_lt_14}{
Numeric (0 or 1). Glasgow Coma Scale score < 14 (i.e., 13 or lower). (1 = Yes).
}
  \item{abdominal_tenderness}{
Numeric (0 or 1). Presence of abdominal tenderness on examination (mild, moderate, or severe). (1 = Yes).
}
  \item{thoracic_wall_trauma}{
Numeric (0 or 1). Evidence of thoracic wall trauma (pain, tenderness, contusion, abrasion). (1 = Yes).
}
  \item{abdominal_pain}{
Numeric (0 or 1). Patient complaint of abdominal pain. (1 = Yes).
}
  \item{decreased_breath_sounds}{
Numeric (0 or 1). Decreased or absent breath sounds on auscultation. (1 = Yes).
}
  \item{vomiting}{
Numeric (0 or 1). Any vomiting associated with the trauma. (1 = Yes).
}
}
\value{
A list containing:
\item{PECARN_IAI_Risk_Factors}{The total count of positive predictors present.}
\item{Risk_Category}{Classification (Very Low Risk vs. Not Very Low Risk).}
\item{Risk_of_Intervention}{Estimated probability of IAI requiring acute intervention (laparotomy, angiographic embolization, blood transfusion, or IV fluids for >2 nights).}
}
\references{
Holmes JF, Lillis K, Monroe D, et al. Identifying children at very low risk of clinically important blunt abdominal injuries. Ann Emerg Med. 2013;62(2):107-116.e2. doi:10.1016/j.annemergmed.2012.11.009
}
\examples{

# Example 1: Very Low Risk
# No symptoms or signs
pecarn_pediatric_iai_algorithm(0, 0, 0, 0, 0, 0, 0)

# Example 2: Not Very Low Risk
# Seatbelt sign (1), Abdominal pain (1)
# Score = 2
pecarn_pediatric_iai_algorithm(1, 0, 0, 0, 1, 0, 0)
}
