\name{paxlovid_eligibility_check}
\alias{paxlovid_eligibility_check}
\title{
Indications for Paxlovid Prescribing
}
\description{
Determines eligibility and appropriate dosing for Paxlovid (nirmatrelvir/ritonavir) therapy in patients with mild-to-moderate COVID-19. The function evaluates inclusion criteria (age, weight, risk factors, timing) and exclusion criteria (renal/hepatic impairment, drug interactions) based on FDA Emergency Use Authorization guidelines.
}
\usage{
paxlovid_eligibility_check(covid_positive, symptom_onset_days, age_years,
                           weight_kg, has_risk_factors, egfr_ml_min,
                           severe_hepatic_impairment, significant_drug_interactions)
}
\arguments{
  \item{covid_positive}{
Numeric (0 or 1). Confirmed positive SARS-CoV-2 test. (1 = Yes).
}
  \item{symptom_onset_days}{
Numeric. Days since symptom onset. (Must be <= 5 days for eligibility).
}
  \item{age_years}{
Numeric. Patient age in years. (Must be >= 12 for eligibility).
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms. (Must be >= 40 kg for eligibility).
}
  \item{has_risk_factors}{
Numeric (0 or 1). Does the patient have one or more risk factors for progression to severe COVID-19 (e.g., age >= 50, cancer, diabetes, obesity, cardiovascular disease)? (1 = Yes).
}
  \item{egfr_ml_min}{
Numeric. Estimated Glomerular Filtration Rate (mL/min). Used for dosing adjustment. (<30 is contraindicated).
}
  \item{severe_hepatic_impairment}{
Numeric (0 or 1). Presence of severe hepatic impairment (Child-Pugh Class C). (1 = Yes).
}
  \item{significant_drug_interactions}{
Numeric (0 or 1). Use of medications that are highly dependent on CYP3A for clearance or are potent CYP3A inducers, where interactions cannot be managed. (1 = Yes).
}
}
\value{
A list containing:
\item{Status}{"Eligible" or "Not Eligible / Contraindicated".}
\item{Recommendation}{Specific dosing instructions (Standard vs. Renal dose) or "None".}
\item{Reason_for_Ineligibility}{Explanation if the patient is not eligible.}
}
\references{
FDA Fact Sheet for Healthcare Providers: Emergency Use Authorization for Paxlovid. U.S. Food and Drug Administration.
}
\examples{

# Example 1: Eligible Standard Dose
# Positive, Day 3, 50yo, 80kg, Risk Factors, eGFR 90, No issues
paxlovid_eligibility_check(1, 3, 50, 80, 1, 90, 0, 0)

# Example 2: Eligible Renal Dose
# Positive, Day 4, 65yo, 70kg, Risk Factors, eGFR 45, No issues
paxlovid_eligibility_check(1, 4, 65, 70, 1, 45, 0, 0)

# Example 3: Contraindicated (eGFR)
# Positive, Day 2, 70yo, 70kg, Risk Factors, eGFR 20
paxlovid_eligibility_check(1, 2, 70, 70, 1, 20, 0, 0)
}
