\name{patient_activity_scale_ra}
\alias{patient_activity_scale_ra}
\title{
Patient Activity Scale (PAS) and PAS-II for Rheumatoid Arthritis
}
\description{
Calculates the Patient Activity Scale (PAS) and PAS-II to assess disease activity in Rheumatoid Arthritis. These scores rely entirely on patient-reported outcomes: Pain VAS, Patient Global Assessment VAS, and the Health Assessment Questionnaire-II (HAQ-II).
}
\usage{
patient_activity_scale_ra(pain_vas, patient_global_vas, haq_ii_items)
}
\arguments{
  \item{pain_vas}{
Numeric (0-10). Patient's assessment of pain on a visual analog scale.
}
  \item{patient_global_vas}{
Numeric (0-10). Patient's global assessment of disease activity on a visual analog scale.
}
  \item{haq_ii_items}{
Numeric vector of length 10. Scores for the 10 HAQ-II items (0=No difficulty, 1=Some difficulty, 2=Much difficulty, 3=Unable to do). Items include:
1. Stand up from a straight chair?
2. Walk outdoors on flat ground?
3. Walk up 5 steps?
4. Wash entire body?
5. Reach and get down a 5lb object from above head?
6. Open car door?
7. Do outside work (yard work)?
8. Wait in line for 15 minutes?
9. Lift heavy objects?
10. Move heavy objects?
}
}
\value{
A list containing:
\item{PAS_Score}{The standard PAS score (Range 0-10).}
\item{PAS_II_Score}{The PAS-II score (Range 0-10), often preferred for logarithmic scaling properties.}
\item{Disease_Activity}{Classification (Remission <= 0.25, Low <= 3.7, Moderate < 8.0, High >= 8.0 based on PAS-II).}
}
\references{
Wolfe F, Michaud K, Pincus T. Development and validation of the health assessment questionnaire II: a revised version of the health assessment questionnaire. Arthritis Rheum. 2004;50(10):3296-3305. doi:10.1002/art.20549
}
\examples{

# Example 1: High Activity
# Pain 8, Global 9, HAQ-II mostly 2s and 3s
haq_high <- c(2, 2, 3, 1, 3, 2, 3, 1, 3, 2)
patient_activity_scale_ra(8, 9, haq_high)

# Example 2: Remission
# Pain 0, Global 0, HAQ-II all 0
haq_low <- rep(0, 10)
patient_activity_scale_ra(0, 0, haq_low)
}
