\name{nyha_functional_classification}
\alias{nyha_functional_classification}
\title{
New York Heart Association (NYHA) Functional Classification
}
\description{
Retrieves the clinical description for the NYHA Functional Classification. This system provides a simple way of classifying the extent of heart failure based on the severity of symptoms and physical activity limitation.
}
\usage{
nyha_functional_classification(class_grade)
}
\arguments{
  \item{class_grade}{
Numeric (1-4). The assessed NYHA Class.
1: No limitation of physical activity.
2: Slight limitation of physical activity.
3: Marked limitation of physical activity.
4: Unable to carry on any physical activity without discomfort; symptoms at rest.
}
}
\value{
A list containing:
\item{NYHA_Class}{The formatted class string (e.g., "Class I").}
\item{Description}{The clinical definition associated with the class.}
}
\references{
The Criteria Committee of the New York Heart Association. Nomenclature and Criteria for Diagnosis of Diseases of the Heart and Great Vessels. 9th ed. Boston, Mass: Little, Brown & Co; 1994:253-256.
}
\examples{

# Example 1: Class II (Slight limitation)
nyha_functional_classification(2)

# Example 2: Class IV (Symptoms at rest)
nyha_functional_classification(4)
}
