\name{mysec_pm_score}
\alias{mysec_pm_score}
\title{
MYSEC-PM Score for Secondary Myelofibrosis
}
\description{
Calculates the MYSEC-PM (Myelofibrosis Secondary to PV and ET-Prognostic Model) score. This tool is specifically designed to predict overall survival in patients with myelofibrosis that has evolved from Polycythemia Vera (PV) or Essential Thrombocythemia (ET), known as secondary myelofibrosis. It stratifies patients into four risk categories.
}
\usage{
mysec_pm_score(age, hemoglobin_g_dl, platelet_count, circulating_blasts_percent,
               calr_unmutated, constitutional_symptoms)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (< 11 g/dL adds points).
}
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L. (< 150 x 10^9/L adds points).
}
  \item{circulating_blasts_percent}{
Numeric. Percentage of circulating blasts in peripheral blood. (>= 3\% adds points).
}
  \item{calr_unmutated}{
Numeric (0 or 1). Is the CALR genotype unmutated? (1 = Yes). Note: Patients with JAK2 or MPL mutations, or "Triple Negative" status, are considered CALR unmutated for this score. Only confirmed CALR mutations are 0.
}
  \item{constitutional_symptoms}{
Numeric (0 or 1). Presence of constitutional symptoms (weight loss >10\% in 6 months, unexplained fever, or excessive sweating). (1 = Yes).
}
}
\value{
A list containing:
\item{MYSEC_PM_Score}{The calculated prognostic score.}
\item{Risk_Category}{Classification (Low < 11, Intermediate-1 11-14, Intermediate-2 14-16, High >= 16).}
\item{Median_Overall_Survival}{Estimated median survival time.}
}
\references{
Passamonti F, Giorgino T, Mora B, et al. A clinical-molecular prognostic model to predict survival in patients with post polycythemia vera and post essential thrombocythemia myelofibrosis. Leukemia. 2017;31(12):2726-2731. doi:10.1038/leu.2017.169
}
\examples{

# Example 1: High Risk
# 70yo (16.1 pts), no other factors
# Score = 16.1
mysec_pm_score(70, 12, 200, 1, 0, 0)

# Example 2: Low Risk
# 40yo (9.2 pts), no other factors
# Score = 9.2
mysec_pm_score(40, 12, 200, 0, 0, 0)
}
