\name{mskcc_gist_recurrence_risk}
\alias{mskcc_gist_recurrence_risk}
\title{
MSKCC Risk of Recurrence for GIST
}
\description{
Calculates the likelihood of recurrence-free survival (RFS) at 2 and 5 years after complete surgical resection of a localized primary Gastrointestinal Stromal Tumor (GIST). This nomogram (Goldjsher et al.) uses tumor size, location, and mitotic index.
}
\usage{
mskcc_gist_recurrence_risk(tumor_size_cm, tumor_site, mitotic_index_ge_5)
}
\arguments{
  \item{tumor_size_cm}{
Numeric. Largest diameter of the tumor in centimeters.
}
  \item{tumor_site}{
String. Location of the tumor. Options: "stomach", "small_intestine", "colon_rectum", "other".
}
  \item{mitotic_index_ge_5}{
Numeric (0 or 1). Mitotic index >= 5 per 50 High Power Fields (HPF). (1 = Yes).
}
}
\value{
A list containing:
\item{Recurrence_Free_Survival_2yr}{Estimated percentage of patients recurrence-free at 2 years.}
\item{Recurrence_Free_Survival_5yr}{Estimated percentage of patients recurrence-free at 5 years.}
\item{Risk_of_Recurrence_2yr}{Estimated percentage risk of recurrence within 2 years.}
\item{Risk_of_Recurrence_5yr}{Estimated percentage risk of recurrence within 5 years.}
}
\references{
Goldjsher D, Joanis V, DeMatteo RP, et al. Development and validation of a prognostic nomogram for recurrence-free survival after complete surgical resection of localized, primary gastrointestinal stromal tumor: a retrospective analysis. Lancet Oncol. 2009;10(11):1045-1052. doi:10.1016/S1470-2045(09)70242-6
}
\examples{

# Example 1: Low Risk
# 3cm Stomach GIST, Low Mitosis
mskcc_gist_recurrence_risk(3, "stomach", 0)

# Example 2: High Risk
# 12cm Small Bowel GIST, High Mitosis
mskcc_gist_recurrence_risk(12, "small_intestine", 1)
}
