\name{mekhail_motzer_score}
\alias{mekhail_motzer_score}
\title{
Mekhail Extension of the Motzer Score for Metastatic RCC
}
\description{
Calculates the Mekhail Extension of the Motzer Score (MSKCC Score) for prognosis in patients with metastatic Renal Cell Carcinoma (mRCC) who have received prior immunotherapy or chemotherapy. This model adds "Metastasis in >= 2 organs" to the original 5 Motzer risk factors.
}
\usage{
mekhail_motzer_score(time_to_treatment_lt_1y, kps_lt_80, hemoglobin_low,
                     calcium_high, ldh_high, metastasis_sites_ge_2)
}
\arguments{
  \item{time_to_treatment_lt_1y}{
Numeric (0 or 1). Time from initial diagnosis to start of systemic treatment < 1 year. (1 = Yes).
}
  \item{kps_lt_80}{
Numeric (0 or 1). Karnofsky Performance Status < 80\%. (1 = Yes).
}
  \item{hemoglobin_low}{
Numeric (0 or 1). Serum hemoglobin less than the lower limit of normal. (1 = Yes).
}
  \item{calcium_high}{
Numeric (0 or 1). Corrected serum calcium > 10 mg/dL (2.5 mmol/L). (1 = Yes).
}
  \item{ldh_high}{
Numeric (0 or 1). Lactate Dehydrogenase > 1.5x Upper Limit of Normal. (1 = Yes).
}
  \item{metastasis_sites_ge_2}{
Numeric (0 or 1). Metastasis in 2 or more organs. (1 = Yes).
}
}
\value{
A list containing:
\item{Mekhail_Score}{The total count of risk factors present (Range 0-6).}
\item{Risk_Group}{Classification (Favorable: 0, Intermediate: 1-2, Poor: >=3).}
\item{Median_Overall_Survival}{Estimated median survival time based on the validation cohort.}
}
\references{
Mekhail TM, Abou-Jawde RM, Boumerhi G, et al. Validation and extension of the Memorial Sloan-Kettering prognostic factors model for survival in patients with previously treated metastatic renal cell carcinoma. J Clin Oncol. 2005;23(4):832-841. doi:10.1200/JCO.2005.05.179
}
\examples{

# Example 1: Poor Risk
# KPS 70 (1), Anemia (1), 3 Metastatic Sites (1)
# Score = 3
mekhail_motzer_score(0, 1, 1, 0, 0, 1)

# Example 2: Favorable Risk
# No risk factors
# Score = 0
mekhail_motzer_score(0, 0, 0, 0, 0, 0)
}
