\name{mascc_risk_index}
\alias{mascc_risk_index}
\title{
MASCC Risk Index for Febrile Neutropenia
}
\description{
Calculates the Multinational Association for Supportive Care in Cancer (MASCC) Risk Index to identify low-risk patients with febrile neutropenia. A score >= 21 indicates a low risk of complications, suggesting that the patient may be eligible for outpatient management and/or oral antibiotics.
}
\usage{
mascc_risk_index(burden_severity, hypotension_present, copd_history, tumor_type,
                 previous_fungal_infection, dehydration_present, outpatient_status,
                 age)
}
\arguments{
  \item{burden_severity}{
String. Burden of febrile neutropenia illness. Options: "none_mild" (+5 pts), "moderate" (+3 pts), "severe" (0 pts).
}
  \item{hypotension_present}{
Numeric (0 or 1). Presence of hypotension (Systolic BP < 90 mmHg). (1 = Yes, 0 pts; 0 = No, +5 pts).
}
  \item{copd_history}{
Numeric (0 or 1). History of Chronic Obstructive Pulmonary Disease. (1 = Yes, 0 pts; 0 = No, +4 pts).
}
  \item{tumor_type}{
String. Type of malignancy. "solid" or "hematologic".
}
  \item{previous_fungal_infection}{
Numeric (0 or 1). Previous fungal infection (only relevant for hematologic malignancy). (1 = Yes).
Note: Solid tumor OR (Hematologic malignancy with NO previous fungal infection) adds +4 pts.
}
  \item{dehydration_present}{
Numeric (0 or 1). Dehydration requiring parenteral fluids. (1 = Yes, 0 pts; 0 = No, +3 pts).
}
  \item{outpatient_status}{
Numeric (0 or 1). Patient status at onset of fever. (1 = Outpatient, +3 pts; 0 = Inpatient, 0 pts).
}
  \item{age}{
Numeric. Patient age in years. (< 60 years adds +2 pts).
}
}
\value{
A list containing:
\item{MASCC_Score}{The calculated total score (Range 0-26).}
\item{Risk_Category}{"Low Risk" (>= 21) or "High Risk" (< 21).}
\item{Recommendation}{Clinical guidance regarding disposition and therapy.}
}
\references{
Klastersky J, Paesmans M, Rubenstein EB, et al. The Multinational Association for Supportive Care in Cancer risk index: A multinational scoring system for identifying low-risk febrile neutropenic cancer patients. J Clin Oncol. 2000;18(16):3038-3051. doi:10.1200/JCO.2000.18.16.3038
}
\examples{

# Example 1: Low Risk
# Mild symptoms, No hypotension, No COPD, Solid tumor, No dehydration, Outpatient, Age 45
# Score = 5 + 5 + 4 + 4 + 3 + 3 + 2 = 26
mascc_risk_index("none_mild", 0, 0, "solid", 0, 0, 1, 45)

# Example 2: High Risk
# Severe symptoms, Hypotension, Heme malignancy with fungal hx, Inpatient, Age 70
# Score = 0 + 0 + 4 + 0 + 3 + 0 + 0 = 7
mascc_risk_index("severe", 1, 0, "hematologic", 1, 0, 0, 70)
}
