\name{madrs_depression_score}
\alias{madrs_depression_score}
\title{
Montgomery-Asberg Depression Rating Scale (MADRS)
}
\description{
Calculates the MADRS score, a 10-item clinician-rated scale used to measure the severity of depressive episodes in patients with mood disorders. Each item is rated on a 0-6 scale, yielding a total score from 0 to 60. It is widely used to monitor treatment response.
}
\usage{
madrs_depression_score(apparent_sadness, reported_sadness, inner_tension,
                       reduced_sleep, reduced_appetite, concentration_difficulties,
                       lassitude, inability_to_feel, pessimistic_thoughts,
                       suicidal_thoughts)
}
\arguments{
  \item{apparent_sadness}{Numeric (0-6). Despondency, gloom, and despair (more than just ordinary transient low spirits) reflected in speech, facial expression, and posture.}
  \item{reported_sadness}{Numeric (0-6). Representing reports of depressed mood, regardless of whether it is reflected in appearance or not.}
  \item{inner_tension}{Numeric (0-6). Representing feelings of ill-defined discomfort, edginess, inner turmoil, mental tension mounting to either panic, dread, or anguish.}
  \item{reduced_sleep}{Numeric (0-6). Representing a subjective experience of reduced duration or depth of sleep compared to the subject's own normal pattern when well.}
  \item{reduced_appetite}{Numeric (0-6). Representing the feeling of a loss of appetite compared with when well.}
  \item{concentration_difficulties}{Numeric (0-6). Representing difficulties in collecting one's thoughts mounting to incapacitating lack of concentration.}
  \item{lassitude}{Numeric (0-6). Representing a difficulty getting started or slowness initiating and performing everyday activities.}
  \item{inability_to_feel}{Numeric (0-6). Representing the subjective experience of reduced interest in the surroundings, or activities that normally give pleasure.}
  \item{pessimistic_thoughts}{Numeric (0-6). Representing thoughts of guilt, inferiority, self-reproach, sinfulness, remorse, and ruin.}
  \item{suicidal_thoughts}{Numeric (0-6). Representing the feeling that life is not worth living, that a natural death would be welcome, suicidal thoughts, and preparations for suicide.}
}
\value{
A list containing:
\item{MADRS_Score}{The calculated total score (Range 0-60).}
\item{Severity_Category}{Interpretation (Normal 0-6, Mild 7-19, Moderate 20-34, Severe >34).}
}
\references{
Montgomery SA, Asberg M. A new depression scale designed to be sensitive to change. Br J Psychiatry. 1979;134:382-389. doi:10.1192/bjp.134.4.382
}
\examples{

# Example 1: Moderate Depression
# Most items scored 3 (Moderate)
madrs_depression_score(3, 3, 3, 3, 3, 3, 3, 3, 3, 3)

# Example 2: Severe Depression
# High scores across emotional and vegetative symptoms
madrs_depression_score(5, 5, 4, 4, 2, 4, 5, 4, 4, 3)
}
