\name{local_anesthetic_dosing}
\alias{local_anesthetic_dosing}
\title{
Local Anesthetic Dosing Calculator
}
\description{
Calculates the maximum safe dose (in milligrams and milliliters) of common local anesthetics based on patient weight, specific drug properties, and the presence of epinephrine. It accounts for both weight-based limits and absolute maximum total dose limits.
}
\usage{
local_anesthetic_dosing(weight_kg, anesthetic_type, concentration_percent,
                        with_epinephrine = 0)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{anesthetic_type}{
String. The generic name of the anesthetic. Supported: "lidocaine", "bupivacaine", "mepivacaine", "ropivacaine", "procaine", "chloroprocaine", "tetracaine".
}
  \item{concentration_percent}{
Numeric. The concentration of the solution in percent (e.g., 1 for 1\%, 0.5 for 0.5\%).
}
  \item{with_epinephrine}{
Numeric (0 or 1). Is the anesthetic mixed with epinephrine? (1 = Yes, 0 = No). Presence of epinephrine typically increases the maximum safe dose for certain agents (e.g., Lidocaine, Mepivacaine) by vasoconstriction, delaying systemic absorption.
}
}
\value{
A list containing:
\item{Max_Dose_mg}{The calculated maximum safe dose in milligrams.}
\item{Max_Volume_mL}{The calculated maximum safe volume in milliliters.}
\item{Constraint}{Indicates whether the dose was limited by the weight-based calculation or the absolute maximum ceiling.}
}
\references{
Rosenberg PH, Veering BT, Urmey WF. Maximum recommended doses of local anesthetics: a multifactorial concept. Reg Anesth Pain Med. 2004;29(6):564-575. doi:10.1016/j.rapm.2004.08.003
}
\examples{

# Example 1: Lidocaine w/ Epi for 70kg adult (1% solution)
# Max dose 7 mg/kg -> 490 mg. Max Vol = 490 / 10 = 49 mL.
local_anesthetic_dosing(70, "lidocaine", 1, 1)

# Example 2: Bupivacaine Plain for 50kg patient (0.25% solution)
# Max dose 2.5 mg/kg -> 125 mg. Conc = 2.5 mg/mL. Max Vol = 125 / 2.5 = 50 mL.
local_anesthetic_dosing(50, "bupivacaine", 0.25, 0)
}
