\name{kruis_ibs_score}
\alias{kruis_ibs_score}
\title{
Kruis Score for Irritable Bowel Syndrome (IBS)
}
\description{
Calculates the Kruis Score to assist in the diagnosis of Irritable Bowel Syndrome (IBS). The score differentiates IBS from organic bowel disease based on history, symptom characteristics, and basic physical/laboratory findings.
}
\usage{
kruis_ibs_score(symptoms_triad, odd_pain_description, alternating_bowel_habits,
                duration_gt_2yr, abdominal_mass, leukocytosis, elevated_esr,
                positive_fob)
}
\arguments{
  \item{symptoms_triad}{
Numeric (0 or 1). Presence of the triad: Abdominal pain, flatulence, and irregularity of bowel movements. (1 = Yes, +34 pts).
}
  \item{odd_pain_description}{
Numeric (0 or 1). Patient describes pain as "burning", "cutting", "very strong", "terrible", "feeling of pressure", "dull", "boring", or "not so bad". (1 = Yes, 0 pts; 0 = No, +23 pts).
}
  \item{alternating_bowel_habits}{
Numeric (0 or 1). Alternating constipation and diarrhea. (1 = Yes, +14 pts).
}
  \item{duration_gt_2yr}{
Numeric (0 or 1). Duration of symptoms > 2 years. (1 = Yes, +16 pts).
}
  \item{abdominal_mass}{
Numeric (0 or 1). Abdominal mass palpable on exam. (1 = Yes, 0 pts; 0 = No, +16 pts).
}
  \item{leukocytosis}{
Numeric (0 or 1). Leukocytosis (> 10,000 /uL). (1 = Yes, 0 pts; 0 = No, +16 pts).
}
  \item{elevated_esr}{
Numeric (0 or 1). ESR > 20 mm/hr (or >10 depending on lab). (1 = Yes, 0 pts; 0 = No, +13 pts).
}
  \item{positive_fob}{
Numeric (0 or 1). Positive Fecal Occult Blood test. (1 = Yes, 0 pts; 0 = No, +12 pts).
}
}
\value{
A list containing:
\item{Kruis_Score}{The calculated total score.}
\item{Result}{Diagnostic interpretation ("Diagnosed as IBS" if Score > 44).}
}
\references{
Kruis W, Thieme C, Weinzierl M, et al. A diagnostic score for the irritable bowel syndrome. Its value in the exclusion of organic disease. Gastroenterology. 1984;87(1):1-7.
}
\examples{

# Example 1: Likely IBS
# Symptoms triad (1), No odd pain (0), Alternating (1), >2yr (1), No mass (0), No labs (0)
# Score = 34 + 23 + 14 + 16 + 16 + 16 + 13 + 12 = 144
kruis_ibs_score(1, 0, 1, 1, 0, 0, 0, 0)

# Example 2: Possible Organic Disease
# No triad (0), Odd pain desc (1), No alternating (0), Short duration (0), Mass (1), Labs normal (0)
# Score = 0 + 0 + 0 + 0 + 0 + 16 + 13 + 12 = 41 (<=44)
kruis_ibs_score(0, 1, 0, 0, 1, 0, 0, 0)
}
