\name{kawasaki_disease_criteria}
\alias{kawasaki_disease_criteria}
\title{
Kawasaki Disease Diagnostic Criteria
}
\description{
Evaluates the clinical diagnostic criteria for Kawasaki Disease (KD). According to the American Heart Association (AHA) guidelines, diagnosis of Complete KD requires fever for at least 5 days plus the presence of at least 4 of the 5 principal clinical features.
}
\usage{
kawasaki_disease_criteria(fever_ge_5_days, conjunctivitis, oral_mucosal_changes,
                          extremity_changes, polymorphous_rash,
                          cervical_lymphadenopathy)
}
\arguments{
  \item{fever_ge_5_days}{
Numeric (0 or 1). Fever persisting for at least 5 days. (1 = Yes).
}
  \item{conjunctivitis}{
Numeric (0 or 1). Bilateral bulbar conjunctival injection without exudate. (1 = Yes).
}
  \item{oral_mucosal_changes}{
Numeric (0 or 1). Changes in lips and oral cavity (e.g., erythema, cracked lips, strawberry tongue). (1 = Yes).
}
  \item{extremity_changes}{
Numeric (0 or 1). Changes in extremities (e.g., edema, erythema of palms/soles, desquamation). (1 = Yes).
}
  \item{polymorphous_rash}{
Numeric (0 or 1). Polymorphous exanthem. (1 = Yes).
}
  \item{cervical_lymphadenopathy}{
Numeric (0 or 1). Cervical lymphadenopathy (>1.5 cm diameter), usually unilateral. (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis_Result}{Classification as "Complete Kawasaki Disease", "Incomplete Kawasaki Disease (Possible)", or "Criteria Not Met".}
\item{Criteria_Count}{The number of principal clinical features present (excluding fever).}
\item{Recommendation}{Clinical guidance based on the criteria met.}
}
\references{
McCrindle BW, Rowley AH, Newburger JW, et al. Diagnosis, Treatment, and Long-Term Management of Kawasaki Disease: A Scientific Statement for Health Professionals From the American Heart Association. Circulation. 2017;135(17):e927-e999. doi:10.1161/CIR.0000000000000484
}
\examples{

# Example 1: Complete KD
# Fever >= 5 days, 4 clinical signs
kawasaki_disease_criteria(1, 1, 1, 1, 1, 0)

# Example 2: Incomplete KD Suspected
# Fever >= 5 days, 2 clinical signs
kawasaki_disease_criteria(1, 1, 0, 1, 0, 0)

# Example 3: Criteria Not Met
# Fever < 5 days
kawasaki_disease_criteria(0, 1, 1, 1, 1, 1)
}
