\name{irae_pneumonitis_grading}
\alias{irae_pneumonitis_grading}
\title{
irAE Grading for Pneumonitis (Lung Toxicities)
}
\description{
Calculates the CTCAE severity grade for pneumonitis associated with immune checkpoint inhibitor (ICPi) therapy. Grading is based on clinical symptoms (asymptomatic vs. symptomatic), radiographic findings, and the need for oxygen supplementation or urgent intervention.
}
\usage{
irae_pneumonitis_grading(asymptomatic, symptomatic, severe_symptoms,
                         life_threatening, hypoxia_on_room_air, oxygen_needed,
                         oxygen_management)
}
\arguments{
  \item{asymptomatic}{
Numeric (0 or 1). Asymptomatic, radiographic findings only? (1 = Yes).
}
  \item{symptomatic}{
Numeric (0 or 1). Symptomatic (e.g., cough, dyspnea), but not severe? (1 = Yes).
}
  \item{severe_symptoms}{
Numeric (0 or 1). Severe symptoms or limiting self-care ADL? (1 = Yes).
}
  \item{life_threatening}{
Numeric (0 or 1). Life-threatening respiratory compromise? (1 = Yes).
}
  \item{hypoxia_on_room_air}{
Numeric (0 or 1). Hypoxia present on room air? (1 = Yes). Indicates Grade >= 3.
}
  \item{oxygen_needed}{
Numeric (0 or 1). Oxygen supplementation required? (1 = Yes).
}
  \item{oxygen_management}{
String. Type of oxygen support (optional for grading logic but useful for context). Options: "none", "low_flow", "high_flow", "intubation".
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (0-4).}
\item{Definition}{Clinical description of the grade.}
\item{Management_Recommendation}{Guidance on ICPi continuation and immunosuppressive therapy based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Grade 2 (Symptomatic)
# Cough/Dyspnea, No O2 needed
irae_pneumonitis_grading(0, 1, 0, 0, 0, 0, "none")

# Example 2: Grade 3 (Hypoxia)
# Severe symptoms, Hypoxia on room air, O2 needed
irae_pneumonitis_grading(0, 1, 1, 0, 1, 1, "low_flow")
}
