\name{irae_hepatitis_grading}
\alias{irae_hepatitis_grading}
\title{
irAE Grading for Hepatitis (GI Toxicities)
}
\description{
Calculates the CTCAE severity grade for immune-mediated hepatitis associated with immune checkpoint inhibitor (ICPi) therapy. Grading is based on the elevation of liver transaminases (AST/ALT) and Total Bilirubin relative to the Upper Limit of Normal (ULN).
}
\usage{
irae_hepatitis_grading(ast, alt, total_bilirubin, ast_uln, alt_uln, bilirubin_uln)
}
\arguments{
  \item{ast}{
Numeric. Patient's current AST level.
}
  \item{alt}{
Numeric. Patient's current ALT level.
}
  \item{total_bilirubin}{
Numeric. Patient's current Total Bilirubin level.
}
  \item{ast_uln}{
Numeric. The laboratory's Upper Limit of Normal for AST.
}
  \item{alt_uln}{
Numeric. The laboratory's Upper Limit of Normal for ALT.
}
  \item{bilirubin_uln}{
Numeric. The laboratory's Upper Limit of Normal for Total Bilirubin.
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (0-4).}
\item{Definition}{The criteria met for the specific grade.}
\item{Management_Recommendation}{Guidance on ICPi continuation and immunosuppressive therapy based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Grade 3 Hepatitis
# AST 250 (ULN 40 -> 6.25x), Bili Normal
irae_hepatitis_grading(250, 40, 1.0, 40, 40, 1.2)

# Example 2: Grade 1 Hepatitis
# ALT 80 (ULN 40 -> 2x), Bili Normal
irae_hepatitis_grading(30, 80, 0.8, 40, 40, 1.2)
}
