\name{ich_score}
\alias{ich_score}
\title{
Intracerebral Hemorrhage (ICH) Score
}
\description{
Calculates the ICH Score to estimate 30-day mortality in patients with spontaneous intracerebral hemorrhage. The score is a simple clinical grading scale ranging from 0 to 6, derived from the Glasgow Coma Scale (GCS), ICH volume, presence of intraventricular hemorrhage (IVH), infratentorial origin, and age.
}
\usage{
ich_score(gcs_score, ich_volume_cm3, intraventricular_hemorrhage,
          infratentorial_origin, age_years)
}
\arguments{
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score on admission (3-15).
3-4: +2 pts.
5-12: +1 pt.
13-15: 0 pts.
}
  \item{ich_volume_cm3}{
Numeric. Volume of the hematoma in cubic centimeters. (>= 30 cm3 adds 1 point).
}
  \item{intraventricular_hemorrhage}{
Numeric (0 or 1). Presence of intraventricular hemorrhage. (1 = Yes, +1 point).
}
  \item{infratentorial_origin}{
Numeric (0 or 1). Is the hemorrhage infratentorial in origin (e.g., brainstem, cerebellum)? (1 = Yes, +1 point).
}
  \item{age_years}{
Numeric. Patient age in years. (>= 80 years adds 1 point).
}
}
\value{
A list containing:
\item{ICH_Score}{The calculated total score (Range 0-6).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage based on the derivation cohort.}
}
\references{
Hemphill JC 3rd, Bonovich DC, Besmertis L, Manley GT, Johnston SC. The ICH score: a simple, reliable grading scale for intracerebral hemorrhage. Stroke. 2001;32(4):891-897. doi:10.1161/01.str.32.4.891
}
\examples{

# Example 1: High Mortality
# GCS 4 (+2), Vol 40 (+1), IVH Yes (+1), Infratentorial Yes (+1), Age 85 (+1)
# Score = 6
ich_score(4, 40, 1, 1, 85)

# Example 2: Low Mortality
# GCS 15 (0), Vol 10 (0), No IVH (0), Supratentorial (0), Age 60 (0)
# Score = 0
ich_score(15, 10, 0, 0, 60)
}
