\name{icc_systemic_mastocytosis_criteria}
\alias{icc_systemic_mastocytosis_criteria}
\title{
ICC Diagnostic Criteria for Systemic Mastocytosis (2022)
}
\description{
Evaluates the International Consensus Classification (ICC) diagnostic criteria for Systemic Mastocytosis (SM). Diagnosis requires either one Major criterion + at least one Minor criterion, OR at least three Minor criteria.
}
\usage{
icc_systemic_mastocytosis_criteria(major_criterion_multifocal_infiltrates,
                                   minor_criterion_spindle_mast_cells,
                                   minor_criterion_kit_mutation,
                                   minor_criterion_cd25_expression,
                                   minor_criterion_tryptase_gt_20,
                                   minor_criterion_cd30_expression_bmm)
}
\arguments{
  \item{major_criterion_multifocal_infiltrates}{
Numeric (0 or 1). Multifocal dense infiltrates of mast cells (>=15 mast cells in aggregates) detected in sections of bone marrow and/or other extracutaneous organ(s). (1 = Yes).
}
  \item{minor_criterion_spindle_mast_cells}{
Numeric (0 or 1). >25\% of all mast cells are atypical cells (type I or type II) on bone marrow smears or are spindle-shaped in mast cell infiltrates detected on sections of bone marrow or other extracutaneous organ(s). (1 = Yes).
}
  \item{minor_criterion_kit_mutation}{
Numeric (0 or 1). KIT D816V mutation or other activating KIT mutation detected in bone marrow, blood, or other extracutaneous organ(s). (1 = Yes).
}
  \item{minor_criterion_cd25_expression}{
Numeric (0 or 1). Mast cells in bone marrow, blood, or other extracutaneous organ(s) express CD25 (with or without CD2). (1 = Yes).
}
  \item{minor_criterion_tryptase_gt_20}{
Numeric (0 or 1). Serum total tryptase persistently > 20 ng/mL (in absence of unrelated myeloid neoplasm). (1 = Yes).
}
  \item{minor_criterion_cd30_expression_bmm}{
Numeric (0 or 1). Mast cells in bone marrow display abnormal CD30 expression (Note: This is specific to Bone Marrow Mastocytosis/BMM context in some classifications, but included as a minor criterion in ICC updates for SM). (1 = Yes). *Note: MDCalc implementation often lists CD25/CD2/CD30 under the immunophenotype criterion. This function separates CD25 and CD30 if treated distinctly or groups them if standard.*
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Major_Criteria_Met}{Boolean indicating presence of the major criterion.}
\item{Minor_Criteria_Count}{Count of minor criteria met.}
}
\references{
Arber DA, Orazi A, Hasserjian RP, et al. International Consensus Classification of Myeloid Neoplasms and Acute Leukemias: integrating morphologic, clinical, and genomic data. Blood. 2022;140(11):1200-1228. doi:10.1182/blood.2022015850
}
\examples{

# Example 1: Diagnosis Met (1 Major + 1 Minor)
# Major infiltrates (1), KIT mutation (1)
icc_systemic_mastocytosis_criteria(1, 0, 1, 0, 0, 0)

# Example 2: Diagnosis Met (3 Minor)
# No Major, Spindle cells (1), KIT mutation (1), CD25 (1)
icc_systemic_mastocytosis_criteria(0, 1, 1, 1, 0, 0)
}
