\name{hep_hit_score}
\alias{hep_hit_score}
\title{
HIT Expert Probability (HEP) Score
}
\description{
Calculates the HEP Score to estimate the pre-test probability of Heparin-Induced Thrombocytopenia (HIT). This expert-derived scoring system is more detailed than the 4Ts score and is often used to rule out HIT with high sensitivity.
}
\usage{
hep_hit_score(platelet_fall_percent, timing_code, nadir_platelet_count,
              thrombosis_code, skin_necrosis, acute_systemic_reaction,
              bleeding, other_causes_present)
}
\arguments{
  \item{platelet_fall_percent}{
Numeric. Percentage drop in platelet count (0-100).
<30: -1 pt.
30-50: +1 pt.
>50: +3 pts.
}
  \item{timing_code}{
Numeric. Code for timing of platelet fall relative to heparin exposure.
0: <4 days (first exposure).
1: Day 4.
2: Days 5-10.
3: Days 11-14.
4: >14 days.
5: Rapid onset (<48h) with recent exposure.
6: Rapid onset (>48h) with recent exposure.
}
  \item{nadir_platelet_count}{
Numeric. Lowest platelet count recorded (x 10^9/L).
<=20: -2 pts.
>20: +2 pts.
}
  \item{thrombosis_code}{
Numeric. 0=None, 1=New Thrombosis (+3 pts), 2=Progression of existing thrombosis (+2 pts).
}
  \item{skin_necrosis}{
Numeric (0 or 1). Skin necrosis at injection sites. (1 = Yes, +3 pts).
}
  \item{acute_systemic_reaction}{
Numeric (0 or 1). Acute systemic reaction to heparin bolus. (1 = Yes, +2 pts).
}
  \item{bleeding}{
Numeric (0 or 1). Presence of bleeding. (1 = Yes, -1 pt).
}
  \item{other_causes_present}{
Numeric (0 or 1). Presence of other causes for thrombocytopenia (e.g., sepsis, DIC, non-heparin meds). (1 = Yes, -2 pts; 0 = No, +3 pts).
}
}
\value{
A list containing:
\item{HEP_Score}{The calculated total score.}
\item{Probability}{Risk interpretation (High >= 2, Low < 2).}
}
\references{
Cuker A, Arepally G, Crowther MA, et al. The HIT Expert Probability (HEP) Score: a novel pre-test probability model for heparin-induced thrombocytopenia based on broad expert opinion. J Thromb Haemost. 2010;8(12):2642-2650. doi:10.1111/j.1538-7836.2010.04059.x
}
\examples{

# Example 1: High Probability
# Fall 60% (+3), Timing 7 days (2 -> +3), Nadir 50 (+2), New Clot (1 -> +3), No others (+3)
# Score = 14
hep_hit_score(60, 2, 50, 1, 0, 0, 0, 0)

# Example 2: Low Probability
# Fall 20% (-1), Timing <4d (0 -> -2), Nadir 10 (-2), Bleeding (1 -> -1), Other cause (1 -> -2)
# Score = -8
hep_hit_score(20, 0, 10, 0, 0, 0, 1, 1)
}
