\name{fong_crs_score}
\alias{fong_crs_score}
\title{
Fong Clinical Risk Score (CRS) for Colorectal Cancer Recurrence
}
\description{
Calculates the Fong Clinical Risk Score (CRS) to predict recurrence and survival in patients undergoing resection of hepatic metastases from colorectal cancer. The score is based on five clinical criteria: nodal status of the primary tumor, disease-free interval, number of hepatic tumors, preoperative CEA level, and size of the largest hepatic tumor.
}
\usage{
fong_crs_score(nodal_status_primary, disease_free_interval_lt_12mo,
               num_tumors_gt_1, preop_cea_gt_200, largest_tumor_gt_5cm)
}
\arguments{
  \item{nodal_status_primary}{
Numeric (0 or 1). Node-positive primary tumor. (1 = Yes, +1 point).
}
  \item{disease_free_interval_lt_12mo}{
Numeric (0 or 1). Disease-free interval from primary diagnosis to discovery of liver metastases < 12 months. (1 = Yes, +1 point).
}
  \item{num_tumors_gt_1}{
Numeric (0 or 1). Number of hepatic tumors > 1. (1 = Yes, +1 point).
}
  \item{preop_cea_gt_200}{
Numeric (0 or 1). Preoperative Carcinoembryonic Antigen (CEA) level > 200 ng/mL. (1 = Yes, +1 point).
}
  \item{largest_tumor_gt_5cm}{
Numeric (0 or 1). Size of the largest hepatic tumor > 5 cm. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Fong_Score}{The calculated risk score (Range 0-5).}
\item{Risk_Group}{Classification (Low, Intermediate, High).}
\item{Est_5_Year_Survival}{Estimated 5-year survival probability.}
\item{Median_Survival}{Estimated median survival time in months.}
}
\references{
Fong Y, Fortner J, Sun RL, Brennan MF, Blumgart LH. Clinical score for predicting recurrence after hepatic resection for metastatic colorectal cancer: analysis of 1001 consecutive cases. Ann Surg. 1999;230(3):309-318. doi:10.1097/00000658-199909000-00004
}
\examples{

# Example 1: High Risk
# Node+ Primary, DFI < 12mo, Multiple tumors, CEA 50, Size 3cm
# Score = 1 + 1 + 1 + 0 + 0 = 3
fong_crs_score(1, 1, 1, 0, 0)

# Example 2: Low Risk
# Node Negative, DFI > 12mo, Single tumor, CEA < 200, Size < 5cm
# Score = 0
fong_crs_score(0, 0, 0, 0, 0)
}
