\name{edinburgh_gastric_ulcer_score}
\alias{edinburgh_gastric_ulcer_score}
\title{
Edinburgh Gastric Ulcer Score (EGUS)
}
\description{
Calculates the Edinburgh Gastric Ulcer Score (EGUS) to assess the risk of malignancy in patients with gastric ulcers and determine the need for repeat endoscopic surveillance. The score is derived from patient age, ulcer size, and ulcer location.
}
\usage{
edinburgh_gastric_ulcer_score(age, ulcer_size_cm, ulcer_location)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
< 68: 0 points.
68-79: 1 point.
>= 80: 2 points.
}
  \item{ulcer_size_cm}{
Numeric. Size of the ulcer in centimeters.
< 1.25 cm: 0 points.
1.25 - 2.99 cm: 2 points.
>= 3.00 cm: 3 points.
}
  \item{ulcer_location}{
String. Location of the ulcer: "antral" (0 points) or "non-antral" (1 point).
}
}
\value{
A list containing:
\item{EGUS_Score}{The calculated risk score (Range 0-6).}
\item{Risk_Category}{Classification (Low Risk: 0-2, High Risk: >=3).}
\item{Recommendation}{Clinical guidance regarding the necessity of repeat endoscopy.}
}
\references{
Grant RK, Brindle W, Cameron E, et al. Risk stratifying gastric ulcers: development and validation of a scoring system. Gut. 2021.
}
\examples{

# Example 1: High Risk
# 70yo (+1), 2.0cm ulcer (+2), Non-antral (+1)
# Score = 4
edinburgh_gastric_ulcer_score(70, 2.0, "non-antral")

# Example 2: Low Risk
# 50yo (0), 0.5cm ulcer (0), Antral (0)
# Score = 0
edinburgh_gastric_ulcer_score(50, 0.5, "antral")
}
