\name{canadian_syncope_risk_score}
\alias{canadian_syncope_risk_score}
\title{
Canadian Syncope Risk Score (CSRS)
}
\description{
Calculates the Canadian Syncope Risk Score to predict the 30-day risk of serious adverse events in patients presenting to the Emergency Department with syncope. The score integrates clinical evaluation, ECG/lab investigations, and the final ED diagnosis.
}
\usage{
canadian_syncope_risk_score(vasovagal_predisposition, heart_disease_history,
                            sbp_any, sbp_ed, troponin_elevated,
                            axis_qrs_qt_abnormal, ed_diagnosis_cardiac,
                            ed_diagnosis_vasovagal)
}
\arguments{
  \item{vasovagal_predisposition}{
Numeric (0 or 1). Clinical predispositions for vasovagal syncope (e.g., emotional distress, prolonged standing). (1 = Yes, -1 point).
}
  \item{heart_disease_history}{
Numeric (0 or 1). History of structural heart disease, arrhythmia, or CAD. (1 = Yes, +1 point).
}
  \item{sbp_any}{
Numeric (0 or 1). Was SBP < 90 or > 180 mmHg at any time during ED visit? (1 = Yes, +2 points). Note: The function argument 'sbp_ed' is kept for compatibility but logic uses 'sbp_any' as the primary flag for abnormal BP.
}
  \item{sbp_ed}{
Numeric. Included for flexibility, treated as redundant to sbp_any in standard scoring logic if binary flag used.
}
  \item{troponin_elevated}{
Numeric (0 or 1). Troponin level above 99th percentile. (1 = Yes, +2 points).
}
  \item{axis_qrs_qt_abnormal}{
Numeric (0 or 1). Abnormal QRS axis (<-30 or >100), duration (>130ms), or QTc (>480ms). (1 = Yes, +1 point).
}
  \item{ed_diagnosis_cardiac}{
Numeric (0 or 1). ED Physician diagnosis is Cardiac Syncope. (1 = Yes, +2 points).
}
  \item{ed_diagnosis_vasovagal}{
Numeric (0 or 1). ED Physician diagnosis is Vasovagal Syncope. (1 = Yes, -2 points).
}
}
\value{
A list containing:
\item{CSRS_Score}{The calculated risk score (Range -3 to 11).}
\item{Risk_Category}{Classification (Very Low, Low, Medium, High, Very High).}
\item{Est_30_Day_Serious_Outcome_Risk}{Estimated percentage risk of serious adverse events.}
}
\references{
Thiruganasambandamoorthy V, Kwong K, Wells GA, et al. Development of the Canadian Syncope Risk Score to predict serious adverse events within 30 days of emergency department disposition. CMAJ. 2016;188(12):E289-E298. doi:10.1503/cmaj.151469
}
\examples{

# Example 1: Very Low Risk
# Vasovagal predisposition (-1), ED Dx Vasovagal (-2)
# Score = -3
canadian_syncope_risk_score(1, 0, 0, 0, 0, 0, 0, 1)

# Example 2: High Risk
# Heart Disease (+1), Abnormal SBP (+2), Troponin (+2), Cardiac Dx (+2)
# Score = 7
canadian_syncope_risk_score(0, 1, 1, 0, 1, 0, 1, 0)
}
