\name{calculate_urine_anion_gap}
\alias{calculate_urine_anion_gap}
\title{
Urine Anion Gap
}
\description{
Calculates the Urine Anion Gap (UAG) to evaluate the cause of normal anion gap metabolic acidosis. The UAG serves as a surrogate for urinary ammonium (NH4+) excretion. A negative UAG implies appropriate urinary acidification (high NH4+, often due to GI bicarbonate loss), while a positive UAG suggests a renal acidification defect (low NH4+, e.g., Renal Tubular Acidosis).
}
\usage{
calculate_urine_anion_gap(urine_sodium, urine_potassium, urine_chloride)
}
\arguments{
  \item{urine_sodium}{
Numeric. Urine Sodium concentration in mmol/L or mEq/L.
}
  \item{urine_potassium}{
Numeric. Urine Potassium concentration in mmol/L or mEq/L.
}
  \item{urine_chloride}{
Numeric. Urine Chloride concentration in mmol/L or mEq/L.
}
}
\details{
The formula is:
\deqn{UAG = (U_{Na} + U_{K}) - U_{Cl}}
Interpretation:
\itemize{
  \item \strong{Negative Gap}: Suggests GI bicarbonate loss (e.g., diarrhea).
  \item \strong{Positive Gap}: Suggests Renal Tubular Acidosis (RTA).
}
}
\value{
A list containing:
\item{Urine_Anion_Gap}{The calculated urine anion gap.}
\item{Interpretation}{Diagnostic suggestion based on the gap polarity.}
}
\references{
Goldstein MB, Bear R, Richardson RM, et al. The urine anion gap: a clinically useful index of ammonium excretion. Am J Med Sci. 1986;292(4):198-202. doi:10.1097/00000441-198610000-00003
}
\examples{

# Example 1: Negative Gap (GI Loss)
# Na 40, K 20, Cl 80 -> (40+20)-80 = -20
calculate_urine_anion_gap(40, 20, 80)

# Example 2: Positive Gap (RTA)
# Na 40, K 20, Cl 50 -> (40+20)-50 = 10
calculate_urine_anion_gap(40, 20, 50)
}
