\name{bwh_egg_freezing_tool}
\alias{bwh_egg_freezing_tool}
\title{
BWH Egg Freezing Counseling Tool (EFCT)
}
\description{
Calculates the likelihood of achieving at least one, two, or three live births from elective oocyte cryopreservation (egg freezing). The model is based on data from Brigham and Women's Hospital (BWH) and accounts for the patient's age at retrieval and the number of mature oocytes frozen. It estimates the probability based on age-specific oocyte-to-blastocyst and blastocyst-to-euploidy conversion rates.
}
\usage{
bwh_egg_freezing_tool(age, num_mature_eggs)
}
\arguments{
  \item{age}{
Numeric. The patient's age at the time of egg freezing (Valid range: 24-44 years).
}
  \item{num_mature_eggs}{
Numeric. The number of mature (MII) oocytes frozen.
}
}
\value{
A list containing:
\item{Likelihood_Live_Birth}{A list of probabilities (\%) for having at least 1, 2, or 3 live births.}
\item{Model_Efficiency_Per_Egg}{The approximate probability of a single egg resulting in a live birth for the given age.}
}
\references{
Goldman RH, Racowsky C, Farland LV, et al. Predicting the likelihood of live birth for elective oocyte cryopreservation: a counseling tool for physicians and patients. Hum Reprod. 2017;32(4):853-859. doi:10.1093/humrep/dex008
}
\examples{

# Example 1: 35-year-old with 10 eggs
# Expected: ~69\% chance of at least 1 live birth
bwh_egg_freezing_tool(35, 10)

# Example 2: 40-year-old with 20 eggs
# Expected: ~51\% chance of at least 1 live birth
bwh_egg_freezing_tool(40, 20)
}
