\name{brue_risk_stratification}
\alias{brue_risk_stratification}
\title{
Brief Resolved Unexplained Event (BRUE) Risk Stratification
}
\description{
Stratifies infants presenting with a Brief Resolved Unexplained Event (BRUE) into "Low Risk" or "Not Low Risk" categories based on the 2016 American Academy of Pediatrics (AAP) guidelines. Low-risk classification requires meeting rigorous age, history, and event characteristics criteria, allowing for less invasive management.
}
\usage{
brue_risk_stratification(age_days, gestational_age_weeks,
                         duration_less_than_1_min, cpr_performed,
                         recurring_event, concerning_history_or_exam)
}
\arguments{
  \item{age_days}{
Numeric. Infant's chronological age in days. (Must be > 60 days for Low Risk).
}
  \item{gestational_age_weeks}{
Numeric. Gestational age at birth in weeks. (Must be >= 32 weeks for Low Risk).
}
  \item{duration_less_than_1_min}{
Numeric (0 or 1). Was the duration of the event < 1 minute? (1 = Yes).
}
  \item{cpr_performed}{
Numeric (0 or 1). Was CPR performed by a trained provider? (1 = Yes).
}
  \item{recurring_event}{
Numeric (0 or 1). Has more than one event occurred? (1 = Yes).
}
  \item{concerning_history_or_exam}{
Numeric (0 or 1). Are there concerning findings in the history (e.g., family history of sudden death) or physical exam (e.g., injury, fever)? (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Category}{"Low Risk BRUE" or "Not Low Risk (High Risk) BRUE".}
\item{Recommendation}{Guidance on disposition and workup.}
\item{Criteria_Not_Met}{List of specific factors that excluded the patient from the Low Risk category.}
}
\references{
Tieder JS, Bonkowsky JL, Etzel RA, et al. Clinical Practice Guideline: Brief Resolved Unexplained Events (Formerly Apparent Life-Threatening Events) and Evaluation of Lower-Risk Infants. Pediatrics. 2016;138(1):e20160590. doi:10.1542/peds.2016-0590
}
\examples{

# Example 1: Low Risk
# 90 days old, born at 40 weeks, short event, no CPR, first time, normal exam
brue_risk_stratification(90, 40, 1, 0, 0, 0)

# Example 2: Not Low Risk (Age)
# 45 days old (Too young), otherwise benign
brue_risk_stratification(45, 40, 1, 0, 0, 0)

# Example 3: Not Low Risk (Prematurity)
# 70 days old (Chronological OK), born at 30 weeks (GA < 32)
brue_risk_stratification(70, 30, 1, 0, 0, 0)
}
